/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.commons.crypto.random.AbstractRandom;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.CryptoRandomFactory;
import org.apache.commons.crypto.random.DummyRandom;
import org.apache.commons.crypto.random.FailingRandom;
import org.apache.commons.crypto.random.JavaCryptoRandom;
import org.apache.commons.crypto.random.OpenSslCryptoRandom;
import org.apache.commons.crypto.random.OsCryptoRandom;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CryptoRandomFactoryTest {
    @Test(expected=NullPointerException.class)
    public void testNull() throws Exception {
        CryptoRandomFactory.getCryptoRandom(null);
    }

    @Test
    public void testEmpty() throws Exception {
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", "");
        CryptoRandomFactory.getCryptoRandom((Properties)props);
    }

    @Test
    public void testDefaultRandom() throws GeneralSecurityException {
        Properties props = new Properties();
        CryptoRandom random = CryptoRandomFactory.getCryptoRandom((Properties)props);
        String name = random.getClass().getName();
        if (OpenSslCryptoRandom.isNativeCodeEnabled()) {
            Assert.assertEquals((Object)OpenSslCryptoRandom.class.getName(), (Object)name);
        } else {
            Assert.assertEquals((Object)JavaCryptoRandom.class.getName(), (Object)name);
        }
    }

    @Test
    public void testGetOSRandom() throws GeneralSecurityException {
        Assume.assumeTrue((!System.getProperty("os.name").contains("Windows") ? 1 : 0) != 0);
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", CryptoRandomFactory.RandomProvider.OS.getClassName());
        CryptoRandom random = CryptoRandomFactory.getCryptoRandom((Properties)props);
        Assert.assertEquals((Object)OsCryptoRandom.class.getName(), (Object)random.getClass().getName());
    }

    @Test
    public void testFullClassName() throws GeneralSecurityException {
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", JavaCryptoRandom.class.getName());
        CryptoRandom random = CryptoRandomFactory.getCryptoRandom((Properties)props);
        Assert.assertEquals((Object)JavaCryptoRandom.class.getName(), (Object)random.getClass().getName());
    }

    @Test(expected=GeneralSecurityException.class)
    public void testInvalidRandom() throws GeneralSecurityException {
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.secure.random.classes", "InvalidCipherName");
        CryptoRandomFactory.getCryptoRandom((Properties)properties);
    }

    @Test
    public void testInvalidRandomClass() throws GeneralSecurityException {
        Properties properties = new Properties();
        properties.setProperty("org.apache.commons.crypto.cipher", "OpenSsl");
        CryptoRandom rand = CryptoRandomFactory.getCryptoRandom((Properties)properties);
        Assert.assertEquals((Object)OpenSslCryptoRandom.class.getName(), (Object)rand.getClass().getName());
    }

    @Test
    public void testDefaultRandomClass() throws GeneralSecurityException {
        CryptoRandom rand = CryptoRandomFactory.getCryptoRandom();
        Assert.assertEquals((Object)OpenSslCryptoRandom.class.getName(), (Object)rand.getClass().getName());
    }

    @Test
    public void testAbstractRandom() {
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", AbstractRandom.class.getName());
        try {
            CryptoRandomFactory.getCryptoRandom((Properties)props);
            Assert.fail((String)"Expected GeneralSecurityException");
        }
        catch (GeneralSecurityException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("InstantiationException"));
        }
    }

    @Test
    public void testDummmyRandom() {
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", DummyRandom.class.getName());
        try {
            CryptoRandomFactory.getCryptoRandom((Properties)props);
            Assert.fail((String)"Expected GeneralSecurityException");
        }
        catch (GeneralSecurityException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)message, (boolean)message.contains("NoSuchMethodException"));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoClasses() throws Exception {
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", ",");
        CryptoRandomFactory.getCryptoRandom((Properties)props);
    }

    @Test
    public void testFailingRandom() {
        Properties props = new Properties();
        props.setProperty("commons.crypto.secure.random.classes", FailingRandom.class.getName());
        try {
            CryptoRandomFactory.getCryptoRandom((Properties)props);
            Assert.fail((String)"Expected GeneralSecurityException");
        }
        catch (GeneralSecurityException e) {
            Throwable cause = e.getCause();
            Assert.assertEquals(IllegalArgumentException.class, cause.getClass());
            cause = cause.getCause();
            Assert.assertEquals(InvocationTargetException.class, cause.getClass());
            cause = cause.getCause();
            Assert.assertEquals(UnsatisfiedLinkError.class, cause.getClass());
        }
    }
}

