/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.crypto.random.CryptoRandom;
import org.junit.Test;

public abstract class AbstractRandomTest {
    public abstract CryptoRandom getCryptoRandom() throws GeneralSecurityException;

    @Test(timeout=120000L)
    public void testRandomBytes() throws Exception {
        try (CryptoRandom random = this.getCryptoRandom();){
            this.checkRandomBytes(random, 16);
            this.checkRandomBytes(random, 32);
            this.checkRandomBytes(random, 128);
            this.checkRandomBytes(random, 256);
        }
    }

    @Test(timeout=120000L)
    public void testRandomBytesMultiThreaded() throws Exception {
        int threadCount = 100;
        try (CryptoRandom random = this.getCryptoRandom();){
            ArrayList<Thread> threads = new ArrayList<Thread>(100);
            for (int i = 0; i < 100; ++i) {
                Thread t = new Thread(() -> {
                    this.checkRandomBytes(random, 10);
                    this.checkRandomBytes(random, 1000);
                    this.checkRandomBytes(random, 100000);
                });
                t.start();
                threads.add(t);
            }
            for (Thread t : threads) {
                if (t.getState().equals((Object)Thread.State.NEW)) continue;
                t.join();
            }
        }
    }

    private void checkRandomBytes(CryptoRandom random, int len) {
        byte[] bytes = new byte[len];
        byte[] bytes1 = new byte[len];
        random.nextBytes(bytes);
        random.nextBytes(bytes1);
        while (Arrays.equals(bytes1, new byte[len]) || Arrays.equals(bytes, bytes1)) {
            random.nextBytes(bytes1);
        }
    }
}

