/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.examples;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;

public class StreamExample {
    public static void main(String[] args) throws IOException {
        SecretKeySpec key = new SecretKeySpec(StreamExample.getUTF8Bytes("1234567890123456"), "AES");
        IvParameterSpec iv = new IvParameterSpec(StreamExample.getUTF8Bytes("1234567890123456"));
        Properties properties = new Properties();
        String transform = "AES/CBC/PKCS5Padding";
        String input = "hello world!";
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (CryptoOutputStream cos = new CryptoOutputStream("AES/CBC/PKCS5Padding", properties, (OutputStream)outputStream, (Key)key, (AlgorithmParameterSpec)iv);){
            cos.write(StreamExample.getUTF8Bytes("hello world!"));
            cos.flush();
        }
        System.out.println("Encrypted: " + Arrays.toString(outputStream.toByteArray()));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        try (CryptoInputStream cis = new CryptoInputStream("AES/CBC/PKCS5Padding", properties, (InputStream)inputStream, (Key)key, (AlgorithmParameterSpec)iv);){
            int i;
            byte[] decryptedData = new byte[1024];
            int decryptedLen = 0;
            while ((i = cis.read(decryptedData, decryptedLen, decryptedData.length - decryptedLen)) > -1) {
                decryptedLen += i;
            }
            System.out.println("Decrypted: " + new String(decryptedData, 0, decryptedLen, StandardCharsets.UTF_8));
        }
    }

    private static byte[] getUTF8Bytes(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }
}

