/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.examples;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.CryptoRandomFactory;

public class RandomExample {
    public static void main(String[] args) throws GeneralSecurityException, IOException {
        byte[] key = new byte[16];
        byte[] iv = new byte[32];
        Properties properties = new Properties();
        properties.put("commons.crypto.secure.random.classes", CryptoRandomFactory.RandomProvider.OPENSSL.getClassName());
        try (CryptoRandom random = CryptoRandomFactory.getCryptoRandom((Properties)properties);){
            System.out.println(random.getClass().getCanonicalName());
            random.nextBytes(key);
            random.nextBytes(iv);
        }
        System.out.println(Arrays.toString(key));
        System.out.println(Arrays.toString(iv));
    }
}

