/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.examples;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.CryptoCipherFactory;
import org.apache.commons.crypto.utils.Utils;

public class CipherByteArrayExample {
    public static void main(String[] args) throws Exception {
        SecretKeySpec key = new SecretKeySpec(CipherByteArrayExample.getUTF8Bytes("1234567890123456"), "AES");
        IvParameterSpec iv = new IvParameterSpec(CipherByteArrayExample.getUTF8Bytes("1234567890123456"));
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.cipher.classes", CryptoCipherFactory.CipherProvider.OPENSSL.getClassName());
        String transform = "AES/CBC/PKCS5Padding";
        CryptoCipher encipher = Utils.getCipherInstance((String)"AES/CBC/PKCS5Padding", (Properties)properties);
        System.out.println("Cipher:  " + encipher.getClass().getCanonicalName());
        String sampleInput = "hello world!";
        System.out.println("input:  hello world!");
        byte[] input = CipherByteArrayExample.getUTF8Bytes("hello world!");
        byte[] output = new byte[32];
        encipher.init(1, (Key)key, (AlgorithmParameterSpec)iv);
        int updateBytes = encipher.update(input, 0, input.length, output, 0);
        System.out.println(updateBytes);
        int finalBytes = encipher.doFinal(input, 0, 0, output, updateBytes);
        System.out.println(finalBytes);
        encipher.close();
        System.out.println(Arrays.toString(Arrays.copyOf(output, updateBytes + finalBytes)));
        properties.setProperty("commons.crypto.cipher.classes", CryptoCipherFactory.CipherProvider.JCE.getClassName());
        CryptoCipher decipher = Utils.getCipherInstance((String)"AES/CBC/PKCS5Padding", (Properties)properties);
        System.out.println("Cipher:  " + encipher.getClass().getCanonicalName());
        decipher.init(2, (Key)key, (AlgorithmParameterSpec)iv);
        byte[] decoded = new byte[32];
        decipher.doFinal(output, 0, updateBytes + finalBytes, decoded, 0);
        System.out.println("output: " + new String(decoded, StandardCharsets.UTF_8));
    }

    private static byte[] getUTF8Bytes(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }
}

