/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.apache.commons.crypto.cipher.OpenSsl;
import org.apache.commons.crypto.cipher.OpenSslCipher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class OpenSslCipherTest
extends AbstractCipherTest {
    @Override
    public void init() {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        this.transformations = new String[]{"AES/CBC/NoPadding", "AES/CBC/PKCS5Padding", "AES/CTR/NoPadding"};
        this.cipherClass = OPENSSL_CIPHER_CLASSNAME;
    }

    @Test(expected=NoSuchPaddingException.class, timeout=120000L)
    public void testInvalidPadding() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl.getInstance((String)"AES/CTR/NoPadding2");
    }

    @Test(expected=NoSuchAlgorithmException.class, timeout=120000L)
    public void testInvalidMode() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl.getInstance((String)"AES/CTR2/NoPadding");
    }

    @Test(timeout=120000L)
    public void testUpdateArguments() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        cipher.init(1, KEY, (AlgorithmParameterSpec)new IvParameterSpec(IV));
        ByteBuffer input = ByteBuffer.allocate(1024);
        ByteBuffer output = ByteBuffer.allocate(1024);
        try {
            cipher.update(input, output);
            Assert.fail((String)"Should have failed to accept non-direct buffers.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Direct buffers are required"));
        }
        input = ByteBuffer.allocateDirect(1024);
        output = ByteBuffer.allocateDirect(1000);
        try {
            cipher.update(input, output);
            Assert.fail((String)"Failed to check for output buffer size.");
        }
        catch (ShortBufferException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Output buffer is not sufficient"));
        }
    }

    @Test(timeout=120000L)
    public void testDoFinalArguments() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        cipher.init(1, KEY, (AlgorithmParameterSpec)new IvParameterSpec(IV));
        ByteBuffer input = ByteBuffer.allocate(1024);
        ByteBuffer output = ByteBuffer.allocate(1024);
        try {
            cipher.doFinal(input, output);
            Assert.fail((String)"Should have failed to accept non-direct buffers.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Direct buffer is required"));
        }
    }

    @Override
    @Test(expected=InvalidKeyException.class, timeout=120000L)
    public void testInvalidKey() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        byte[] invalidKey = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17};
        cipher.init(1, invalidKey, (AlgorithmParameterSpec)new IvParameterSpec(IV));
    }

    @Override
    @Test(expected=InvalidAlgorithmParameterException.class, timeout=120000L)
    public void testInvalidIV() throws Exception {
        Assume.assumeTrue((OpenSsl.getLoadingFailureReason() == null ? 1 : 0) != 0);
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        byte[] invalidIV = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17};
        cipher.init(1, KEY, (AlgorithmParameterSpec)new IvParameterSpec(invalidIV));
    }

    @Override
    @Test(expected=InvalidAlgorithmParameterException.class, timeout=120000L)
    public void testInvalidIVClass() throws Exception {
        OpenSsl cipher = OpenSsl.getInstance((String)"AES/CTR/NoPadding");
        Assert.assertNotNull((Object)cipher);
        cipher.init(1, KEY, (AlgorithmParameterSpec)new GCMParameterSpec(IV.length, IV));
    }

    @Test
    public void testCipherLifecycle() throws Exception {
        try (OpenSslCipher cipher = new OpenSslCipher(new Properties(), "AES/CTR/NoPadding");){
            try {
                cipher.update(this.dummyBuffer(), this.dummyBuffer());
                Assert.fail((String)"Should have thrown exception.");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            cipher.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
            cipher.update(this.dummyBuffer(), this.dummyBuffer());
            try {
                cipher.init(1, (Key)new SecretKeySpec(new byte[1], "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
                Assert.fail((String)"Should have thrown exception.");
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
            cipher.update(this.dummyBuffer(), this.dummyBuffer());
            cipher.doFinal(this.dummyBuffer(), this.dummyBuffer());
            cipher.close();
            try {
                cipher.update(this.dummyBuffer(), this.dummyBuffer());
                Assert.fail((String)"Should have thrown exception.");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            cipher.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
            cipher.update(this.dummyBuffer(), this.dummyBuffer());
            cipher.close();
        }
    }

    private ByteBuffer dummyBuffer() {
        return ByteBuffer.allocateDirect(8);
    }
}

