/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.OpenSslCipher;
import org.apache.commons.crypto.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GcmCipherTest {
    Properties props = null;
    String cipherClass = null;
    String transformation = "AES/GCM/NoPadding";
    private String[] kHex;
    private String[] pHex;
    private String[] ivHex;
    private String[] aadHex;
    private String[] cHex;
    private String[] tHex;

    @Before
    public void setup() {
        this.cipherClass = OpenSslCipher.class.getName();
        this.props = new Properties();
        this.props.setProperty("commons.crypto.cipher.classes", this.cipherClass);
        this.initTestData();
    }

    @Test
    public void testGcmNistCase2() throws Exception {
        String kHex = "00000000000000000000000000000000";
        String pHex = "00000000000000000000000000000000";
        String ivHex = "000000000000000000000000";
        String aadHex = "";
        String cHex = "0388dace60b6a392f328c2b971b2fe78";
        String tHex = "ab6e47d42cec13bdf53a67b21257bddf";
        this.testGcmEncryption("00000000000000000000000000000000", "00000000000000000000000000000000", "000000000000000000000000", "", "0388dace60b6a392f328c2b971b2fe78", "ab6e47d42cec13bdf53a67b21257bddf");
        this.testGcmDecryption("00000000000000000000000000000000", "00000000000000000000000000000000", "000000000000000000000000", "", "0388dace60b6a392f328c2b971b2fe78", "ab6e47d42cec13bdf53a67b21257bddf");
        this.testGcmByteBuffer("00000000000000000000000000000000", "00000000000000000000000000000000", "000000000000000000000000", "", "0388dace60b6a392f328c2b971b2fe78", "ab6e47d42cec13bdf53a67b21257bddf");
        this.testGcmReturnDataAfterTagVerified("00000000000000000000000000000000", "00000000000000000000000000000000", "000000000000000000000000", "", "0388dace60b6a392f328c2b971b2fe78", "ab6e47d42cec13bdf53a67b21257bddf");
        this.testGcmArbitraryLengthUpdate("00000000000000000000000000000000", "00000000000000000000000000000000", "000000000000000000000000", "", "0388dace60b6a392f328c2b971b2fe78", "ab6e47d42cec13bdf53a67b21257bddf");
    }

    @Test
    public void testGcmNistCase4() throws Exception {
        String kHex = "feffe9928665731c6d6a8f9467308308";
        String pHex = "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39";
        String ivHex = "cafebabefacedbaddecaf888";
        String aadHex = "feedfacedeadbeeffeedfacedeadbeefabaddad2";
        String cHex = "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091";
        String tHex = "5bc94fbc3221a5db94fae95ae7121a47";
        this.testGcmEncryption("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbaddecaf888", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091", "5bc94fbc3221a5db94fae95ae7121a47");
        this.testGcmDecryption("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbaddecaf888", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091", "5bc94fbc3221a5db94fae95ae7121a47");
        this.testGcmByteBuffer("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbaddecaf888", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091", "5bc94fbc3221a5db94fae95ae7121a47");
        this.testGcmReturnDataAfterTagVerified("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbaddecaf888", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091", "5bc94fbc3221a5db94fae95ae7121a47");
        this.testGcmArbitraryLengthUpdate("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbaddecaf888", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091", "5bc94fbc3221a5db94fae95ae7121a47");
    }

    @Test
    public void testGcmNistCase5() throws Exception {
        String kHex = "feffe9928665731c6d6a8f9467308308";
        String pHex = "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39";
        String ivHex = "cafebabefacedbad";
        String aadHex = "feedfacedeadbeeffeedfacedeadbeefabaddad2";
        String cHex = "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598";
        String tHex = "3612d2e79e3b0785561be14aaca2fccb";
        this.testGcmEncryption("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbad", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598", "3612d2e79e3b0785561be14aaca2fccb");
        this.testGcmDecryption("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbad", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598", "3612d2e79e3b0785561be14aaca2fccb");
        this.testGcmByteBuffer("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbad", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598", "3612d2e79e3b0785561be14aaca2fccb");
        this.testGcmReturnDataAfterTagVerified("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbad", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598", "3612d2e79e3b0785561be14aaca2fccb");
        this.testGcmArbitraryLengthUpdate("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "cafebabefacedbad", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598", "3612d2e79e3b0785561be14aaca2fccb");
    }

    @Test
    public void testGcmNistCase6() throws Exception {
        String kHex = "feffe9928665731c6d6a8f9467308308";
        String pHex = "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39";
        String ivHex = "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b";
        String aadHex = "feedfacedeadbeeffeedfacedeadbeefabaddad2";
        String cHex = "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5";
        String tHex = "619cc5aefffe0bfa462af43c1699d050";
        this.testGcmEncryption("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5", "619cc5aefffe0bfa462af43c1699d050");
        this.testGcmDecryption("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5", "619cc5aefffe0bfa462af43c1699d050");
        this.testGcmByteBuffer("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5", "619cc5aefffe0bfa462af43c1699d050");
        this.testGcmReturnDataAfterTagVerified("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5", "619cc5aefffe0bfa462af43c1699d050");
        this.testGcmArbitraryLengthUpdate("feffe9928665731c6d6a8f9467308308", "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39", "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b", "feedfacedeadbeeffeedfacedeadbeefabaddad2", "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5", "619cc5aefffe0bfa462af43c1699d050");
    }

    @Test
    public void testGcmNistCases() throws Exception {
        for (int i = 0; i < this.kHex.length; ++i) {
            this.testGcmEncryption(this.kHex[i], this.pHex[i], this.ivHex[i], this.aadHex[i], this.cHex[i], this.tHex[i]);
            this.testGcmDecryption(this.kHex[i], this.pHex[i], this.ivHex[i], this.aadHex[i], this.cHex[i], this.tHex[i]);
            this.testGcmByteBuffer(this.kHex[i], this.pHex[i], this.ivHex[i], this.aadHex[i], this.cHex[i], this.tHex[i]);
            this.testGcmReturnDataAfterTagVerified(this.kHex[i], this.pHex[i], this.ivHex[i], this.aadHex[i], this.cHex[i], this.tHex[i]);
            this.testGcmArbitraryLengthUpdate(this.kHex[i], this.pHex[i], this.ivHex[i], this.aadHex[i], this.cHex[i], this.tHex[i]);
        }
    }

    @Test(expected=AEADBadTagException.class)
    public void testGcmTamperedData() throws Exception {
        Random r = new Random();
        int textLength = r.nextInt(0x100000);
        int ivLength = r.nextInt(59) + 1;
        int keyLength = 16;
        int tagLength = 128;
        int aadLength = r.nextInt(128);
        byte[] keyBytes = new byte[16];
        byte[] plainBytes = new byte[textLength];
        byte[] ivBytes = new byte[ivLength];
        byte[] aadBytes = new byte[aadLength];
        r.nextBytes(keyBytes);
        r.nextBytes(plainBytes);
        r.nextBytes(ivBytes);
        r.nextBytes(aadBytes);
        byte[] encOutput = new byte[plainBytes.length + 16];
        byte[] decOutput = new byte[plainBytes.length];
        CryptoCipher c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        c.init(1, (Key)key, (AlgorithmParameterSpec)iv);
        c.updateAAD(aadBytes);
        c.doFinal(plainBytes, 0, plainBytes.length, encOutput, 0);
        c.close();
        encOutput[0] = (byte)(encOutput[0] + 1);
        try {
            c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
            key = new SecretKeySpec(keyBytes, "AES");
            iv = new GCMParameterSpec(128, ivBytes);
            c.init(2, (Key)key, (AlgorithmParameterSpec)iv);
            c.updateAAD(aadBytes);
            c.doFinal(encOutput, 0, encOutput.length, decOutput, 0);
            c.close();
        }
        catch (AEADBadTagException ex) {
            Assert.assertTrue((boolean)"Tag mismatch!".equals(ex.getMessage()));
            throw ex;
        }
    }

    @Test
    public void testGMac() throws Exception {
        Random r = new Random();
        byte[] keyBytes = new byte[32];
        byte[] input = new byte[]{};
        byte[] ivBytes = new byte[16];
        byte[] tag_orig = new byte[16];
        byte[] tag = new byte[16];
        byte[] aad = new byte[r.nextInt() % 1000 + 1000];
        r.nextBytes(keyBytes);
        r.nextBytes(input);
        r.nextBytes(ivBytes);
        r.nextBytes(aad);
        Cipher c = Cipher.getInstance(this.transformation);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        c.init(1, (Key)key, iv);
        c.updateAAD(aad);
        c.doFinal(input, 0, input.length, tag_orig, 0);
        c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        key = new SecretKeySpec(keyBytes, "AES");
        iv = new GCMParameterSpec(128, ivBytes);
        c.init(1, key, iv);
        c.updateAAD(aad);
        c.doFinal(input, 0, input.length, tag, 0);
        c.close();
        Assert.assertArrayEquals((byte[])tag_orig, (byte[])tag);
        c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        key = new SecretKeySpec(keyBytes, "AES");
        iv = new GCMParameterSpec(128, ivBytes);
        c.init(2, key, iv);
        c.updateAAD(aad);
        c.doFinal(tag, 0, tag.length, input, 0);
        c.close();
    }

    @Test(expected=AEADBadTagException.class)
    public void testGMacTamperedData() throws Exception {
        Random r = new Random();
        byte[] keyBytes = new byte[32];
        byte[] input = new byte[]{};
        byte[] ivBytes = new byte[16];
        byte[] tag = new byte[16];
        byte[] aad = new byte[r.nextInt() % 1000 + 1000];
        r.nextBytes(keyBytes);
        r.nextBytes(input);
        r.nextBytes(ivBytes);
        r.nextBytes(aad);
        CryptoCipher c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        c.init(1, (Key)key, (AlgorithmParameterSpec)iv);
        c.updateAAD(aad);
        c.doFinal(input, 0, input.length, tag, 0);
        c.close();
        try {
            c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
            key = new SecretKeySpec(keyBytes, "AES");
            iv = new GCMParameterSpec(128, ivBytes);
            c.init(2, (Key)key, (AlgorithmParameterSpec)iv);
            aad[0] = (byte)(aad[0] + 1);
            c.updateAAD(aad);
            c.doFinal(tag, 0, tag.length, input, 0);
            c.close();
        }
        catch (AEADBadTagException ex) {
            Assert.assertTrue((boolean)"Tag mismatch!".equals(ex.getMessage()));
            throw ex;
        }
    }

    private void testGcmEncryption(String kHex, String pHex, String ivHex, String aadHex, String cHex, String tHex) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseHexBinary((String)kHex);
        byte[] input = DatatypeConverter.parseHexBinary((String)pHex);
        byte[] ivBytes = DatatypeConverter.parseHexBinary((String)ivHex);
        byte[] aad = DatatypeConverter.parseHexBinary((String)aadHex);
        byte[] expectedOutput = DatatypeConverter.parseHexBinary((String)(cHex + tHex));
        byte[] output = new byte[expectedOutput.length];
        CryptoCipher c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        c.init(1, (Key)key, (AlgorithmParameterSpec)iv);
        c.updateAAD(aad);
        c.doFinal(input, 0, input.length, output, 0);
        Assert.assertArrayEquals((byte[])expectedOutput, (byte[])output);
        c.close();
    }

    private void testGcmArbitraryLengthUpdate(String kHex, String pHex, String ivHex, String aadHex, String cHex, String tHex) throws Exception {
        byte[] decInput;
        int partLen;
        int len;
        byte[] keyBytes = DatatypeConverter.parseHexBinary((String)kHex);
        byte[] input = DatatypeConverter.parseHexBinary((String)pHex);
        byte[] ivBytes = DatatypeConverter.parseHexBinary((String)ivHex);
        byte[] aad = DatatypeConverter.parseHexBinary((String)aadHex);
        byte[] expectedOutput = DatatypeConverter.parseHexBinary((String)(cHex + tHex));
        byte[] encOutput = new byte[expectedOutput.length];
        byte[] decOutput = new byte[input.length];
        Random r = new Random();
        CryptoCipher enc = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        enc.init(1, (Key)key, (AlgorithmParameterSpec)iv);
        if (aad.length > 0) {
            int len1 = r.nextInt(aad.length);
            byte[] aad1 = Arrays.copyOfRange(aad, 0, len1);
            byte[] aad2 = Arrays.copyOfRange(aad, len1, aad.length);
            enc.updateAAD(aad1);
            enc.updateAAD(aad2);
        }
        Assert.assertTrue(((len = enc.update(input, 0, partLen = r.nextInt(input.length), encOutput, 0)) == partLen ? 1 : 0) != 0);
        len = enc.doFinal(input, partLen, input.length - partLen, encOutput, partLen);
        Assert.assertTrue((len == input.length + (iv.getTLen() >> 3) - partLen ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])expectedOutput, (byte[])encOutput);
        enc.close();
        CryptoCipher dec = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        dec.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), (AlgorithmParameterSpec)new GCMParameterSpec(128, ivBytes));
        if (aad.length > 0) {
            int len1 = r.nextInt(aad.length);
            byte[] aad1 = Arrays.copyOfRange(aad, 0, len1);
            byte[] aad2 = Arrays.copyOfRange(aad, len1, aad.length);
            dec.updateAAD(aad1);
            dec.updateAAD(aad2);
        }
        Assert.assertTrue(((len = dec.update(decInput = encOutput, 0, partLen = r.nextInt(input.length), decOutput, 0)) == 0 ? 1 : 0) != 0);
        len = dec.doFinal(decInput, partLen, decInput.length - partLen, decOutput, 0);
        Assert.assertTrue((len == input.length ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])input, (byte[])decOutput);
        dec.close();
    }

    private void testGcmDecryption(String kHex, String pHex, String ivHex, String aadHex, String cHex, String tHex) throws Exception {
        byte[] cipherBytes;
        byte[] keyBytes = DatatypeConverter.parseHexBinary((String)kHex);
        byte[] plainBytes = DatatypeConverter.parseHexBinary((String)pHex);
        byte[] ivBytes = DatatypeConverter.parseHexBinary((String)ivHex);
        byte[] aad = DatatypeConverter.parseHexBinary((String)aadHex);
        byte[] input = cipherBytes = DatatypeConverter.parseHexBinary((String)(cHex + tHex));
        byte[] output = new byte[plainBytes.length];
        CryptoCipher c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        c.init(2, (Key)key, (AlgorithmParameterSpec)iv);
        c.updateAAD(aad);
        c.doFinal(input, 0, input.length, output, 0);
        Assert.assertArrayEquals((byte[])plainBytes, (byte[])output);
        c.close();
    }

    private void testGcmReturnDataAfterTagVerified(String kHex, String pHex, String ivHex, String aadHex, String cHex, String tHex) throws Exception {
        byte[] cipherBytes;
        byte[] keyBytes = DatatypeConverter.parseHexBinary((String)kHex);
        byte[] plainBytes = DatatypeConverter.parseHexBinary((String)pHex);
        byte[] ivBytes = DatatypeConverter.parseHexBinary((String)ivHex);
        byte[] aad = DatatypeConverter.parseHexBinary((String)aadHex);
        byte[] input = cipherBytes = DatatypeConverter.parseHexBinary((String)(cHex + tHex));
        byte[] output = new byte[plainBytes.length];
        CryptoCipher c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        c.init(2, (Key)key, (AlgorithmParameterSpec)iv);
        c.updateAAD(aad);
        int len = c.update(input, 0, input.length, output, 0);
        Assert.assertTrue((len == 0 ? 1 : 0) != 0);
        Assert.assertTrue(((len += c.doFinal(input, input.length, 0, output, 0)) == plainBytes.length ? 1 : 0) != 0);
        Assert.assertArrayEquals((byte[])plainBytes, (byte[])output);
        c.close();
    }

    private void testGcmByteBuffer(String kHex, String pHex, String ivHex, String aadHex, String cHex, String tHex) throws Exception {
        byte[] keyBytes = DatatypeConverter.parseHexBinary((String)kHex);
        byte[] plainText = DatatypeConverter.parseHexBinary((String)pHex);
        byte[] ivBytes = DatatypeConverter.parseHexBinary((String)ivHex);
        byte[] aad = DatatypeConverter.parseHexBinary((String)aadHex);
        byte[] cipherText = DatatypeConverter.parseHexBinary((String)(cHex + tHex));
        byte[] encOutput = new byte[cipherText.length];
        byte[] decOutput = new byte[plainText.length];
        ByteBuffer bfAAD = ByteBuffer.allocateDirect(aad.length);
        bfAAD.put(aad);
        ByteBuffer bfPlainText = ByteBuffer.allocateDirect(plainText.length);
        ByteBuffer bfCipherText = ByteBuffer.allocateDirect(encOutput.length);
        CryptoCipher c = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        GCMParameterSpec iv = new GCMParameterSpec(128, ivBytes);
        c.init(1, (Key)key, (AlgorithmParameterSpec)iv);
        bfAAD.flip();
        c.updateAAD(bfAAD);
        bfPlainText.put(plainText);
        bfPlainText.flip();
        bfCipherText.position(0);
        c.doFinal(bfPlainText, bfCipherText);
        bfCipherText.flip();
        bfCipherText.get(encOutput);
        Assert.assertArrayEquals((byte[])cipherText, (byte[])encOutput);
        c.close();
        CryptoCipher dec = Utils.getCipherInstance((String)this.transformation, (Properties)this.props);
        dec.init(2, (Key)new SecretKeySpec(keyBytes, "AES"), (AlgorithmParameterSpec)new GCMParameterSpec(128, ivBytes));
        bfAAD.flip();
        dec.updateAAD(bfAAD);
        bfCipherText.clear();
        bfPlainText.clear();
        bfCipherText.put(cipherText);
        bfCipherText.flip();
        dec.doFinal(bfCipherText, bfPlainText);
        bfPlainText.flip();
        bfPlainText.get(decOutput);
        Assert.assertArrayEquals((byte[])plainText, (byte[])decOutput);
        dec.close();
    }

    private void initTestData() {
        int casesNumber = 4;
        this.kHex = new String[4];
        this.pHex = new String[4];
        this.ivHex = new String[4];
        this.aadHex = new String[4];
        this.cHex = new String[4];
        this.tHex = new String[4];
        this.kHex[0] = "00000000000000000000000000000000";
        this.pHex[0] = "00000000000000000000000000000000";
        this.ivHex[0] = "000000000000000000000000";
        this.aadHex[0] = "";
        this.cHex[0] = "0388dace60b6a392f328c2b971b2fe78";
        this.tHex[0] = "ab6e47d42cec13bdf53a67b21257bddf";
        this.kHex[1] = "feffe9928665731c6d6a8f9467308308";
        this.pHex[1] = "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39";
        this.ivHex[1] = "cafebabefacedbaddecaf888";
        this.aadHex[1] = "feedfacedeadbeeffeedfacedeadbeefabaddad2";
        this.cHex[1] = "42831ec2217774244b7221b784d0d49ce3aa212f2c02a4e035c17e2329aca12e21d514b25466931c7d8f6a5aac84aa051ba30b396a0aac973d58e091";
        this.tHex[1] = "5bc94fbc3221a5db94fae95ae7121a47";
        this.kHex[2] = "feffe9928665731c6d6a8f9467308308";
        this.pHex[2] = "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39";
        this.ivHex[2] = "cafebabefacedbad";
        this.aadHex[2] = "feedfacedeadbeeffeedfacedeadbeefabaddad2";
        this.cHex[2] = "61353b4c2806934a777ff51fa22a4755699b2a714fcdc6f83766e5f97b6c742373806900e49f24b22b097544d4896b424989b5e1ebac0f07c23f4598";
        this.tHex[2] = "3612d2e79e3b0785561be14aaca2fccb";
        this.kHex[3] = "feffe9928665731c6d6a8f9467308308";
        this.pHex[3] = "d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b39";
        this.ivHex[3] = "9313225df88406e555909c5aff5269aa6a7a9538534f7da1e4c303d2a318a728c3c0c95156809539fcf0e2429a6b525416aedbf5a0de6a57a637b39b";
        this.aadHex[3] = "feedfacedeadbeeffeedfacedeadbeefabaddad2";
        this.cHex[3] = "8ce24998625615b603a033aca13fb894be9112a5c3a211a8ba262a3cca7e2ca701e4a9a4fba43c90ccdcb281d48c7c6fd62875d2aca417034c34aee5";
        this.tHex[3] = "619cc5aefffe0bfa462af43c1699d050";
    }
}

