/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import java.util.Random;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.cipher.JceCipher;
import org.apache.commons.crypto.cipher.OpenSslCipher;
import org.apache.commons.crypto.cipher.TestData;
import org.apache.commons.crypto.utils.ReflectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCipherTest {
    public static final String OPENSSL_CIPHER_CLASSNAME = OpenSslCipher.class.getName();
    public static final String JCE_CIPHER_CLASSNAME = JceCipher.class.getName();
    public static final int BYTEBUFFER_SIZE = 1000;
    public String[] cipherTests;
    private Properties props;
    protected String cipherClass;
    protected String[] transformations;
    static final byte[] KEY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 32, 33, 34, 35, 36};
    static final byte[] IV = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 1, 2, 3, 4, 5, 6, 7, 8};
    private CryptoCipher enc;
    private CryptoCipher dec;

    @Before
    public void setup() {
        this.init();
        Assert.assertNotNull((String)"cipherClass", (Object)this.cipherClass);
        Assert.assertNotNull((String)"transformations", (Object)this.transformations);
        this.props = new Properties();
        this.props.setProperty("commons.crypto.cipher.classes", this.cipherClass);
    }

    protected abstract void init();

    @Test
    public void closeTestNoInit() throws Exception {
        CryptoCipher enc = this.getCipher(this.transformations[0]);
        enc.close();
    }

    @Test
    public void closeTestAfterInit() throws Exception {
        CryptoCipher enc = this.getCipher(this.transformations[0]);
        enc.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
        enc.close();
    }

    @Test
    public void reInitTest() throws Exception {
        CryptoCipher enc = this.getCipher(this.transformations[0]);
        enc.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
        enc.init(2, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
        enc.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
        enc.close();
    }

    @Test
    public void reInitAfterClose() throws Exception {
        CryptoCipher enc = this.getCipher(this.transformations[0]);
        enc.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
        enc.close();
        enc.init(2, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
        enc.close();
    }

    @Test
    public void closeTestRepeat() throws Exception {
        CryptoCipher enc = this.getCipher(this.transformations[0]);
        enc.close();
        enc.close();
        enc.close();
    }

    @Test
    public void cryptoTest() throws Exception {
        for (String tran : this.transformations) {
            this.cipherTests = TestData.getTestData(tran);
            Assert.assertNotNull((String)tran, (Object)this.cipherTests);
            for (int i = 0; i != this.cipherTests.length; i += 5) {
                byte[] key = DatatypeConverter.parseHexBinary((String)this.cipherTests[i + 1]);
                byte[] iv = DatatypeConverter.parseHexBinary((String)this.cipherTests[i + 2]);
                byte[] inputBytes = DatatypeConverter.parseHexBinary((String)this.cipherTests[i + 3]);
                byte[] outputBytes = DatatypeConverter.parseHexBinary((String)this.cipherTests[i + 4]);
                ByteBuffer inputBuffer = ByteBuffer.allocateDirect(inputBytes.length);
                ByteBuffer outputBuffer = ByteBuffer.allocateDirect(outputBytes.length);
                inputBuffer.put(inputBytes);
                inputBuffer.flip();
                outputBuffer.put(outputBytes);
                outputBuffer.flip();
                this.byteBufferTest(tran, key, iv, inputBuffer, outputBuffer);
                this.byteArrayTest(tran, key, iv, inputBytes, outputBytes);
            }
            this.byteArrayTest(tran, KEY, IV);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullTransform() throws Exception {
        this.getCipher(null).close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidTransform() throws Exception {
        this.getCipher("AES/CBR/NoPadding/garbage/garbage").close();
    }

    @Test
    public void testInvalidKey() throws Exception {
        for (String transform : this.transformations) {
            try (CryptoCipher cipher = this.getCipher(transform);){
                Assert.assertNotNull((Object)cipher);
                byte[] invalidKey = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17};
                cipher.init(1, (Key)new SecretKeySpec(invalidKey, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV));
                Assert.fail((String)"Expected InvalidKeyException");
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testInvalidIV() throws Exception {
        for (String transform : this.transformations) {
            try (CryptoCipher cipher = this.getCipher(transform);){
                Assert.assertNotNull((Object)cipher);
                byte[] invalidIV = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 17};
                cipher.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(invalidIV));
                Assert.fail((String)"Expected InvalidAlgorithmParameterException");
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testInvalidIVClass() throws Exception {
        for (String transform : this.transformations) {
            try (CryptoCipher cipher = this.getCipher(transform);){
                Assert.assertNotNull((Object)cipher);
                cipher.init(1, (Key)new SecretKeySpec(KEY, "AES"), (AlgorithmParameterSpec)new GCMParameterSpec(IV.length, IV));
                Assert.fail((String)"Should have caught an InvalidAlgorithmParameterException");
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                // empty catch block
            }
        }
    }

    private void byteBufferTest(String transformation, byte[] key, byte[] iv, ByteBuffer input, ByteBuffer output) throws Exception {
        ByteBuffer decResult = ByteBuffer.allocateDirect(1000);
        ByteBuffer encResult = ByteBuffer.allocateDirect(1000);
        try (CryptoCipher enc = this.getCipher(transformation);
             CryptoCipher dec = this.getCipher(transformation);){
            enc.init(1, (Key)new SecretKeySpec(key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
            dec.init(2, (Key)new SecretKeySpec(key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
            enc.doFinal(input, encResult);
            input.flip();
            encResult.flip();
            if (!output.equals(encResult)) {
                byte[] b = new byte[output.remaining()];
                output.get(b);
                byte[] c = new byte[encResult.remaining()];
                encResult.get(c);
                Assert.fail((String)("AES failed encryption - expected " + new String(DatatypeConverter.printHexBinary((byte[])b)) + " got " + new String(DatatypeConverter.printHexBinary((byte[])c))));
            }
            dec.doFinal(encResult, decResult);
            decResult.flip();
            if (!input.equals(decResult)) {
                byte[] inArray = new byte[input.remaining()];
                byte[] decResultArray = new byte[decResult.remaining()];
                input.get(inArray);
                decResult.get(decResultArray);
                Assert.fail();
            }
        }
    }

    private void byteArrayTest(String transformation, byte[] key, byte[] iv, byte[] input, byte[] output) throws Exception {
        this.resetCipher(transformation, key, iv);
        int blockSize = this.enc.getBlockSize();
        byte[] temp = new byte[input.length + blockSize];
        int n = this.enc.doFinal(input, 0, input.length, temp, 0);
        byte[] cipherText = new byte[n];
        System.arraycopy(temp, 0, cipherText, 0, n);
        Assert.assertArrayEquals((String)"byte array encryption error.", (byte[])output, (byte[])cipherText);
        temp = new byte[cipherText.length + blockSize];
        int m = this.dec.doFinal(cipherText, 0, cipherText.length, temp, 0);
        byte[] plainText = new byte[m];
        System.arraycopy(temp, 0, plainText, 0, m);
        Assert.assertArrayEquals((String)"byte array decryption error.", (byte[])input, (byte[])plainText);
    }

    private void byteArrayTest(String transformation, byte[] key, byte[] iv) throws Exception {
        int[] dataLenList;
        int[] nArray;
        int blockSize = this.enc.getBlockSize();
        if (transformation.equals("AES/CBC/NoPadding")) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 10240;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 10240;
            nArray = nArray3;
            nArray3[1] = 10237;
        }
        for (int dataLen : dataLenList = nArray) {
            int[] bufferLenList;
            byte[] plainText = new byte[dataLen];
            SecureRandom random = new SecureRandom();
            ((Random)random).nextBytes(plainText);
            byte[] cipherText = new byte[dataLen + blockSize];
            for (int bufferLen : bufferLenList = new int[]{1920, 1923}) {
                this.resetCipher(transformation, key, iv);
                int offset = 0;
                int cipherPos = 0;
                for (int i = 0; i < dataLen / bufferLen; ++i) {
                    cipherPos += this.enc.update(plainText, offset, bufferLen, cipherText, cipherPos);
                    offset += bufferLen;
                }
                cipherPos += this.enc.doFinal(plainText, offset, dataLen % bufferLen, cipherText, cipherPos);
                offset = 0;
                byte[] realPlainText = new byte[cipherPos + blockSize];
                int plainPos = 0;
                for (int i = 0; i < cipherPos / bufferLen; ++i) {
                    plainPos += this.dec.update(cipherText, offset, bufferLen, realPlainText, plainPos);
                    offset += bufferLen;
                }
                plainPos += this.dec.doFinal(cipherText, offset, cipherPos % bufferLen, realPlainText, plainPos);
                Assert.assertEquals((String)"random byte array length changes after transformation", (long)dataLen, (long)plainPos);
                byte[] shrinkPlainText = new byte[plainPos];
                System.arraycopy(realPlainText, 0, shrinkPlainText, 0, plainPos);
                Assert.assertArrayEquals((String)"random byte array contents changes after transformation", (byte[])plainText, (byte[])shrinkPlainText);
            }
        }
    }

    private void resetCipher(String transformation, byte[] key, byte[] iv) throws ClassNotFoundException, InvalidKeyException, InvalidAlgorithmParameterException {
        this.enc = this.getCipher(transformation);
        this.dec = this.getCipher(transformation);
        this.enc.init(1, (Key)new SecretKeySpec(key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
        this.dec.init(2, (Key)new SecretKeySpec(key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    private CryptoCipher getCipher(String transformation) throws ClassNotFoundException {
        return (CryptoCipher)ReflectionUtils.newInstance((Class)ReflectionUtils.getClassByName((String)this.cipherClass), (Object[])new Object[]{this.props, transformation});
    }
}

