/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto;

import java.io.File;
import org.apache.commons.crypto.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

public class NativeCodeLoaderTest {
    @Test
    public void test() {
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            System.out.println("** INFO: Native (JNI) code loaded successfully");
        } else {
            System.out.println("** WARN: Native (JNI) code was not loaded: " + NativeCodeLoader.getLoadingError());
        }
    }

    @Test
    public void testNativePresent() {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        Assert.assertNull((Object)NativeCodeLoader.getLoadingError());
    }

    @Test
    public void testNativeNotPresent() {
        Assume.assumeTrue((!NativeCodeLoader.isNativeCodeLoaded() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)NativeCodeLoader.getLoadingError());
    }

    @Test
    public void testCanLoadIfPresent() {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
        Assert.assertNull((Object)NativeCodeLoader.loadLibrary());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="Seems to cause issues with other tests on Linux; disable for now")
    public void testUnSuccessfulLoad() throws Exception {
        String nameKey = System.getProperty("commons.crypto.lib.name");
        String pathKey = System.getProperty("commons.crypto.lib.path");
        File empty = File.createTempFile("NativeCodeLoaderTest", "tmp");
        try {
            System.setProperty("commons.crypto.lib.path", empty.getParent());
            System.setProperty("commons.crypto.lib.name", empty.getName());
            Throwable result = NativeCodeLoader.loadLibrary();
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((boolean)(result instanceof UnsatisfiedLinkError));
        }
        finally {
            empty.delete();
            if (nameKey != null) {
                System.setProperty("commons.crypto.lib.name", nameKey);
            }
            if (pathKey != null) {
                System.setProperty("commons.crypto.lib.path", pathKey);
            }
        }
    }
}

