/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto;

import org.apache.commons.crypto.Crypto;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CryptoTest {
    @Test
    public void testGetComponentName() {
        String version = Crypto.getComponentName();
        Assert.assertNotNull((String)"Should not be null", (Object)version);
        Assert.assertTrue((String)version, (boolean)version.matches("^Apache Commons Crypto.*"));
    }

    @Test
    public void testGetComponentVersion() {
        String version = Crypto.getComponentVersion();
        Assert.assertNotNull((String)"Should not be null", (Object)version);
        Assert.assertTrue((String)version, (boolean)version.matches("^\\d+\\.\\d+.*"));
    }

    @Test
    @Ignore(value="Mac64 failure with OpenSSL 1.1.1g")
    public void testMain() throws Throwable {
        try {
            Crypto.main((String[])new String[0]);
        }
        catch (Throwable e) {
            Throwable loadingError = Crypto.getLoadingError();
            System.err.println("Special case; LoadingError = " + loadingError);
            throw loadingError != null ? loadingError : e;
        }
    }

    @Test
    public void testLoadingError() throws Throwable {
        Throwable loadingError = Crypto.getLoadingError();
        if (loadingError != null) {
            throw loadingError;
        }
    }
}

