/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni.avro;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.avro.AvroColumnReader;
import org.apache.trevni.avro.AvroColumnWriter;
import org.junit.Before;
import org.junit.Test;

public class TestEvolvedSchema
extends TestCase {
    private static String writerSchema = "{    \"namespace\": \"org.apache.avro\",    \"name\": \"test_evolution\",    \"type\": \"record\",    \"fields\": [        { \"name\": \"a\", \"type\":\"string\" },        { \"name\": \"b\", \"type\":\"int\" }     ]}";
    private static String innerSchema = "{\"name\":\"c1\",          \"type\":\"record\",          \"fields\":[{\"name\":\"c11\", \"type\":\"int\", \"default\": 2},                      {\"name\":\"c12\", \"type\":\"string\", \"default\":\"goodbye\"}]}";
    private static String evolvedSchema2 = "{    \"namespace\": \"org.apache.avro\",    \"name\": \"test_evolution\",    \"type\": \"record\",    \"fields\": [        { \"name\": \"a\", \"type\":\"string\" },        { \"name\": \"b\", \"type\":\"int\" },        { \"name\": \"c\", \"type\":" + innerSchema + ",          \"default\":{\"c11\": 1, \"c12\": \"hello\"}        }     ]}";
    GenericData.Record writtenRecord;
    GenericData.Record evolvedRecord;
    GenericData.Record innerRecord;
    private static final Schema writer = Schema.parse(writerSchema);
    private static final Schema evolved = Schema.parse(evolvedSchema2);
    private static final Schema inner = Schema.parse(innerSchema);

    @Before
    public void setUp() {
        this.writtenRecord = new GenericData.Record(writer);
        this.writtenRecord.put("a", (Object)"record");
        this.writtenRecord.put("b", (Object)21);
        this.innerRecord = new GenericData.Record(inner);
        this.innerRecord.put("c11", (Object)1);
        this.innerRecord.put("c12", (Object)"hello");
        this.evolvedRecord = new GenericData.Record(evolved);
        this.evolvedRecord.put("a", (Object)"record");
        this.evolvedRecord.put("b", (Object)21);
        this.evolvedRecord.put("c", (Object)this.innerRecord);
    }

    @Test
    public void testTrevniEvolvedRead() throws IOException {
        AvroColumnWriter<GenericData.Record> acw = new AvroColumnWriter<GenericData.Record>(writer, new ColumnFileMetaData());
        acw.write(this.writtenRecord);
        File serializedTrevni = File.createTempFile("trevni", null);
        acw.writeTo(serializedTrevni);
        AvroColumnReader.Params params = new AvroColumnReader.Params(serializedTrevni);
        params.setSchema(evolved);
        AvroColumnReader acr = new AvroColumnReader(params);
        GenericRecord readRecord = (GenericRecord)acr.next();
        TestEvolvedSchema.assertEquals((Object)this.evolvedRecord, (Object)readRecord);
        TestEvolvedSchema.assertFalse((boolean)acr.hasNext());
    }

    @Test
    public void testAvroEvolvedRead() throws IOException {
        File serializedAvro = File.createTempFile("avro", null);
        GenericDatumWriter dw = new GenericDatumWriter(writer);
        DataFileWriter<GenericData.Record> dfw = new DataFileWriter<GenericData.Record>(dw);
        dfw.create(writer, serializedAvro);
        dfw.append(this.writtenRecord);
        dfw.flush();
        dfw.close();
        GenericDatumReader reader = new GenericDatumReader(writer);
        reader.setExpected(evolved);
        DataFileReader dfr = new DataFileReader(serializedAvro, reader);
        GenericRecord readRecord = (GenericRecord)dfr.next();
        TestEvolvedSchema.assertEquals((Object)this.evolvedRecord, (Object)readRecord);
        TestEvolvedSchema.assertFalse((boolean)dfr.hasNext());
    }
}

