/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.apache.hadoop.security.http.XFrameOptionsFilter;
import org.apache.hadoop.yarn.webapp.Dispatcher;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class WebApps {
    static final Logger LOG = LoggerFactory.getLogger(WebApps.class);

    public static <T> Builder<T> $for(String prefix, Class<T> api, T app, String wsPrefix) {
        return new Builder<T>(prefix, api, app, wsPrefix);
    }

    public static <T> Builder<T> $for(String prefix, Class<T> api, T app) {
        return new Builder<T>(prefix, api, app);
    }

    public static <T> Builder<T> $for(String prefix, T app) {
        return WebApps.$for(prefix, app.getClass(), app);
    }

    public static <T> Builder<T> $for(T app) {
        return WebApps.$for("", app);
    }

    public static <T> Builder<T> $for(String prefix) {
        return WebApps.$for(prefix, null, null);
    }

    public static class Builder<T> {
        final String name;
        final String wsName;
        final Class<T> api;
        final T application;
        String bindAddress = "0.0.0.0";
        int port = 0;
        boolean findPort = false;
        Configuration conf;
        HttpConfig.Policy httpPolicy = null;
        boolean needsClientAuth = false;
        String portRangeConfigKey = null;
        boolean devMode = false;
        private String spnegoPrincipalKey;
        private String spnegoKeytabKey;
        private String csrfConfigPrefix;
        private String xfsConfigPrefix;
        private final HashSet<ServletStruct> servlets = new HashSet();
        private final HashMap<String, Object> attributes = new HashMap();

        Builder(String name, Class<T> api, T application, String wsName) {
            this.name = name;
            this.api = api;
            this.application = application;
            this.wsName = wsName;
        }

        Builder(String name, Class<T> api, T application) {
            this(name, api, application, null);
        }

        public Builder<T> at(String bindAddress) {
            String[] parts = StringUtils.split(bindAddress, ':');
            if (parts.length == 2) {
                int port = Integer.parseInt(parts[1]);
                return this.at(parts[0], port, port == 0);
            }
            return this.at(bindAddress, 0, true);
        }

        public Builder<T> at(int port) {
            return this.at("0.0.0.0", port, port == 0);
        }

        public Builder<T> at(String address, int port, boolean findPort) {
            this.bindAddress = Preconditions.checkNotNull(address, "bind address");
            this.port = port;
            this.findPort = findPort;
            return this;
        }

        public Builder<T> withAttribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder<T> withServlet(String name, String pathSpec, Class<? extends HttpServlet> servlet) {
            ServletStruct struct = new ServletStruct();
            struct.clazz = servlet;
            struct.name = name;
            struct.spec = pathSpec;
            this.servlets.add(struct);
            return this;
        }

        public Builder<T> with(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder<T> withHttpPolicy(Configuration conf, HttpConfig.Policy httpPolicy) {
            this.conf = conf;
            this.httpPolicy = httpPolicy;
            return this;
        }

        public Builder<T> needsClientAuth(boolean needsClientAuth) {
            this.needsClientAuth = needsClientAuth;
            return this;
        }

        public Builder<T> withPortRange(Configuration config, String portRangeConfKey) {
            this.conf = config;
            this.portRangeConfigKey = portRangeConfKey;
            return this;
        }

        public Builder<T> withHttpSpnegoPrincipalKey(String spnegoPrincipalKey) {
            this.spnegoPrincipalKey = spnegoPrincipalKey;
            return this;
        }

        public Builder<T> withHttpSpnegoKeytabKey(String spnegoKeytabKey) {
            this.spnegoKeytabKey = spnegoKeytabKey;
            return this;
        }

        public Builder<T> withCSRFProtection(String prefix) {
            this.csrfConfigPrefix = prefix;
            return this;
        }

        public Builder<T> withXFSProtection(String prefix) {
            this.xfsConfigPrefix = prefix;
            return this;
        }

        public Builder<T> inDevMode() {
            this.devMode = true;
            return this;
        }

        public WebApp build(WebApp webapp) {
            if (webapp == null) {
                webapp = new WebApp(){

                    @Override
                    public void setup() {
                    }
                };
            }
            webapp.setName(this.name);
            webapp.setWebServices(this.wsName);
            String basePath = "/" + this.name;
            webapp.setRedirectPath(basePath);
            ArrayList<String> pathList = new ArrayList<String>();
            if (basePath.equals("/")) {
                webapp.addServePathSpec("/*");
                pathList.add("/*");
            } else {
                webapp.addServePathSpec(basePath);
                webapp.addServePathSpec(basePath + "/*");
                pathList.add(basePath + "/*");
            }
            if (this.wsName != null && !this.wsName.equals(basePath)) {
                if (this.wsName.equals("/")) {
                    webapp.addServePathSpec("/*");
                    pathList.add("/*");
                } else {
                    webapp.addServePathSpec("/" + this.wsName);
                    webapp.addServePathSpec("/" + this.wsName + "/*");
                    pathList.add("/" + this.wsName + "/*");
                }
            }
            if (this.conf == null) {
                this.conf = new Configuration();
            }
            try {
                boolean hasSpnegoConf;
                if (this.application != null) {
                    webapp.setHostClass(this.application.getClass());
                } else {
                    String cls = this.inferHostClass();
                    LOG.debug("setting webapp host class to {}", (Object)cls);
                    webapp.setHostClass(Class.forName(cls));
                }
                if (this.devMode) {
                    if (this.port > 0) {
                        try {
                            new URL("http://localhost:" + this.port + "/__stop").getContent();
                            LOG.info("stopping existing webapp instance");
                            Thread.sleep(100L);
                        }
                        catch (ConnectException e) {
                            LOG.info("no existing webapp instance found: {}", (Object)e.toString());
                        }
                        catch (Exception e) {
                            LOG.warn("error stopping existing instance: {}", (Object)e.toString());
                        }
                    } else {
                        LOG.error("dev mode does NOT work with ephemeral port!");
                        System.exit(1);
                    }
                }
                String httpScheme = this.httpPolicy == null ? WebAppUtils.getHttpSchemePrefix(this.conf) : (this.httpPolicy == HttpConfig.Policy.HTTPS_ONLY ? "https://" : "http://");
                HttpServer2.Builder builder = new HttpServer2.Builder().setName(this.name).setConf(this.conf).setFindPort(this.findPort).setACL(new AccessControlList(this.conf.get("yarn.admin.acl", "*"))).setPathSpec(pathList.toArray(new String[0]));
                Configuration.IntegerRanges ranges = null;
                if (this.portRangeConfigKey != null) {
                    ranges = this.conf.getRange(this.portRangeConfigKey, "");
                }
                int startPort = this.port;
                if (ranges != null && !ranges.isEmpty()) {
                    startPort = ranges.getRangeStart();
                    builder.setPortRanges(ranges);
                }
                builder.addEndpoint(URI.create(httpScheme + this.bindAddress + ":" + startPort));
                boolean bl = hasSpnegoConf = this.spnegoPrincipalKey != null && this.conf.get(this.spnegoPrincipalKey) != null && this.spnegoKeytabKey != null && this.conf.get(this.spnegoKeytabKey) != null;
                if (hasSpnegoConf) {
                    builder.setUsernameConfKey(this.spnegoPrincipalKey).setKeytabConfKey(this.spnegoKeytabKey).setSecurityEnabled(UserGroupInformation.isSecurityEnabled());
                }
                if (httpScheme.equals("https://")) {
                    Object amTruststoreLoc;
                    String amKeystoreLoc = System.getenv("KEYSTORE_FILE_LOCATION");
                    if (amKeystoreLoc != null) {
                        LOG.info("Setting keystore location to " + amKeystoreLoc);
                        String password = System.getenv("KEYSTORE_PASSWORD");
                        builder.keyStore(amKeystoreLoc, password, "jks");
                    } else {
                        LOG.info("Loading standard ssl config");
                        WebAppUtils.loadSslConfiguration(builder, this.conf);
                    }
                    builder.needsClientAuth(this.needsClientAuth);
                    if (this.needsClientAuth && (amTruststoreLoc = System.getenv("TRUSTSTORE_FILE_LOCATION")) != null) {
                        LOG.info("Setting truststore location to " + (String)amTruststoreLoc);
                        String string = System.getenv("TRUSTSTORE_PASSWORD");
                        builder.trustStore((String)amTruststoreLoc, string, "jks");
                    }
                }
                HttpServer2 server = builder.build();
                for (ServletStruct servletStruct : this.servlets) {
                    server.addServlet(servletStruct.name, servletStruct.spec, servletStruct.clazz);
                }
                for (Map.Entry entry : this.attributes.entrySet()) {
                    server.setAttribute((String)entry.getKey(), entry.getValue());
                }
                Map<String, String> params = this.getConfigParameters(this.csrfConfigPrefix);
                if (this.hasCSRFEnabled(params)) {
                    LOG.info("CSRF Protection has been enabled for the {} application. Please ensure that there is an authentication mechanism enabled (kerberos, custom, etc).", (Object)this.name);
                    String string = RestCsrfPreventionFilter.class.getName();
                    HttpServer2.defineFilter(server.getWebAppContext(), string, string, params, new String[]{"/*"});
                }
                params = this.getConfigParameters(this.xfsConfigPrefix);
                if (this.hasXFSEnabled()) {
                    String string = XFrameOptionsFilter.class.getName();
                    HttpServer2.defineFilter(server.getWebAppContext(), string, string, params, new String[]{"/*"});
                }
                HttpServer2.defineFilter(server.getWebAppContext(), "guice", GuiceFilter.class.getName(), null, new String[]{"/*"});
                webapp.setConf(this.conf);
                webapp.setHttpServer(server);
            }
            catch (ClassNotFoundException e) {
                throw new WebAppException("Error starting http server", e);
            }
            catch (IOException e) {
                throw new WebAppException("Error starting http server", e);
            }
            Injector injector = Guice.createInjector((Module[])new Module[]{webapp, new AbstractModule(){

                protected void configure() {
                    if (api != null) {
                        this.bind(api).toInstance(application);
                    }
                }
            }});
            LOG.info("Registered webapp guice modules");
            webapp.setGuiceFilter((GuiceFilter)injector.getInstance(GuiceFilter.class));
            if (this.devMode) {
                ((Dispatcher)injector.getInstance(Dispatcher.class)).setDevMode(this.devMode);
                LOG.info("in dev mode!");
            }
            return webapp;
        }

        private boolean hasCSRFEnabled(Map<String, String> params) {
            return params != null && Boolean.valueOf(params.get("enabled")) != false;
        }

        private boolean hasXFSEnabled() {
            return this.conf.getBoolean("yarn.webapp.xfs-filter.enabled", true);
        }

        private Map<String, String> getConfigParameters(String configPrefix) {
            return configPrefix != null ? this.conf.getPropsWithPrefix(configPrefix) : null;
        }

        public WebApp start() {
            return this.start(null);
        }

        public WebApp start(WebApp webapp) {
            return this.start(webapp, null);
        }

        public WebApp start(WebApp webapp, WebAppContext ui2Context) {
            WebApp webApp = this.build(webapp);
            HttpServer2 httpServer = webApp.httpServer();
            if (ui2Context != null) {
                this.addFiltersForNewContext(ui2Context);
                httpServer.addHandlerAtFront(ui2Context);
            }
            try {
                httpServer.start();
                LOG.info("Web app " + this.name + " started at " + httpServer.getConnectorAddress(0).getPort());
            }
            catch (IOException e) {
                throw new WebAppException("Error starting http server", e);
            }
            return webApp;
        }

        private void addFiltersForNewContext(WebAppContext ui2Context) {
            Map<String, String> params = this.getConfigParameters(this.csrfConfigPrefix);
            if (this.hasCSRFEnabled(params)) {
                LOG.info("CSRF Protection has been enabled for the {} application. Please ensure that there is an authentication mechanism enabled (kerberos, custom, etc).", (Object)this.name);
                String restCsrfClassName = RestCsrfPreventionFilter.class.getName();
                HttpServer2.defineFilter(ui2Context, restCsrfClassName, restCsrfClassName, params, new String[]{"/*"});
            }
            params = this.getConfigParameters(this.xfsConfigPrefix);
            if (this.hasXFSEnabled()) {
                String xfsClassName = XFrameOptionsFilter.class.getName();
                HttpServer2.defineFilter(ui2Context, xfsClassName, xfsClassName, params, new String[]{"/*"});
            }
        }

        private String inferHostClass() {
            String thisClass = this.getClass().getName();
            Throwable t = new Throwable();
            for (StackTraceElement e : t.getStackTrace()) {
                if (e.getClassName().equals(thisClass)) continue;
                return e.getClassName();
            }
            LOG.warn("could not infer host class from", t);
            return thisClass;
        }

        static class ServletStruct {
            public Class<? extends HttpServlet> clazz;
            public String name;
            public String spec;

            ServletStruct() {
            }
        }
    }
}

