/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.servlet.RequestScoped;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Params;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.ToJSON;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.view.DefaultPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class Controller
implements Params {
    public static final Logger LOG = LoggerFactory.getLogger(Controller.class);
    static final ObjectMapper jsonMapper = new ObjectMapper();
    private RequestContext context;
    @Inject
    Injector injector;

    public Controller() {
    }

    public Controller(RequestContext ctx) {
        this.context = ctx;
    }

    public RequestContext context() {
        if (this.context == null) {
            if (this.injector == null) {
                throw new WebAppException(StringHelper.join("Error accessing RequestContext from\n", "a child constructor, either move the usage of the Controller\n", "methods out of the constructor or inject the RequestContext\n", "into the constructor"));
            }
            this.context = (RequestContext)this.injector.getInstance(RequestContext.class);
        }
        return this.context;
    }

    public Throwable error() {
        return this.context().error;
    }

    public int status() {
        return this.context().status;
    }

    public void setStatus(int status) {
        this.context().setStatus(status);
    }

    public boolean inDevMode() {
        return this.context().devMode;
    }

    public Injector injector() {
        return this.context().injector;
    }

    public <T> T getInstance(Class<T> cls) {
        return (T)this.injector.getInstance(cls);
    }

    public HttpServletRequest request() {
        return this.context().request;
    }

    public HttpServletResponse response() {
        return this.context().response;
    }

    public void set(String key, String value) {
        this.context().set(key, value);
    }

    public String get(String key, String defaultValue) {
        return this.context().get(key, defaultValue);
    }

    public String $(String key) {
        return this.get(key, "");
    }

    public void setTitle(String title) {
        this.set("title", title);
    }

    public void setTitle(String title, String url) {
        this.setTitle(title);
        this.set("title.href", url);
    }

    public ResponseInfo info(String about) {
        return this.getInstance(ResponseInfo.class).about(about);
    }

    public Map<String, Cookie> cookies() {
        return this.context().cookies();
    }

    public String url(String ... parts) {
        return StringHelper.ujoin(this.context().prefix, parts);
    }

    public abstract void index();

    public void echo() {
        this.render(DefaultPage.class);
    }

    protected void render(Class<? extends View> cls) {
        this.context().rendered = true;
        this.getInstance(cls).render();
    }

    protected void renderJSON(Object object) {
        LOG.debug("{}: {}", (Object)"application/json; charset=UTF-8", object);
        this.context().rendered = true;
        this.context().response.setContentType("application/json; charset=UTF-8");
        try {
            jsonMapper.writeValue(this.writer(), object);
        }
        catch (Exception e) {
            throw new WebAppException(e);
        }
    }

    protected void renderJSON(Class<? extends ToJSON> cls) {
        this.context().rendered = true;
        this.response().setContentType("application/json; charset=UTF-8");
        this.getInstance(cls).toJSON(this.writer());
    }

    protected void renderText(String s) {
        LOG.debug("{}: {}", (Object)"text/plain; charset=UTF-8", (Object)s);
        this.context().rendered = true;
        this.response().setContentType("text/plain; charset=UTF-8");
        this.writer().print(s);
    }

    protected PrintWriter writer() {
        try {
            return this.response().getWriter();
        }
        catch (Exception e) {
            throw new WebAppException(e);
        }
    }

    @RequestScoped
    public static class RequestContext {
        final Injector injector;
        final HttpServletRequest request;
        final HttpServletResponse response;
        private Map<String, String> moreParams;
        private Map<String, Cookie> cookies;
        int status = 200;
        boolean rendered = false;
        Throwable error;
        boolean devMode = false;
        String prefix;

        @Inject
        RequestContext(Injector injector, HttpServletRequest request, HttpServletResponse response) {
            this.injector = injector;
            this.request = request;
            this.response = response;
        }

        public int status() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
            this.response.setStatus(status);
        }

        public void setRendered(boolean rendered) {
            this.rendered = rendered;
        }

        public Map<String, String> moreParams() {
            if (this.moreParams == null) {
                this.moreParams = Maps.newHashMap();
            }
            return this.moreParams;
        }

        public Map<String, Cookie> cookies() {
            if (this.cookies == null) {
                this.cookies = Maps.newHashMap();
                Cookie[] rcookies = this.request.getCookies();
                if (rcookies != null) {
                    for (Cookie cookie : rcookies) {
                        this.cookies.put(cookie.getName(), cookie);
                    }
                }
            }
            return this.cookies;
        }

        public void set(String key, String value) {
            this.moreParams().put(key, value);
        }

        public String get(String key, String defaultValue) {
            String value = this.moreParams().get(key);
            if (value == null) {
                value = this.request.getParameter(key);
            }
            return value == null ? defaultValue : value;
        }

        public String prefix() {
            return this.prefix;
        }
    }
}

