/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.UpdateApplicationTimeoutsResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationTimeout;
import org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.cli.YarnCLI;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.util.Times;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationCLI
extends YarnCLI {
    private static final String APPLICATIONS_PATTERN = "%30s\t%20s\t%20s\t%10s\t%10s\t%18s\t%18s\t%15s\t%35s" + System.getProperty("line.separator");
    private static final String APPLICATION_ATTEMPTS_PATTERN = "%30s\t%20s\t%35s\t%35s" + System.getProperty("line.separator");
    private static final String APP_TYPE_CMD = "appTypes";
    private static final String APP_STATE_CMD = "appStates";
    private static final String APP_TAG_CMD = "appTags";
    private static final String ALLSTATES_OPTION = "ALL";
    private static final String QUEUE_CMD = "queue";
    @VisibleForTesting
    protected static final String CONTAINER_PATTERN = "%30s\t%20s\t%20s\t%20s\t%20s\t%20s\t%35s" + System.getProperty("line.separator");
    public static final String APPLICATION = "application";
    public static final String APPLICATION_ATTEMPT = "applicationattempt";
    public static final String CONTAINER = "container";
    public static final String APP_ID = "appId";
    public static final String UPDATE_PRIORITY = "updatePriority";
    public static final String UPDATE_LIFETIME = "updateLifetime";
    public static final String CHANGE_APPLICATION_QUEUE = "changeQueue";
    private boolean allAppStates;

    public static void main(String[] args) throws Exception {
        ApplicationCLI cli = new ApplicationCLI();
        cli.setSysOutPrintStream(System.out);
        cli.setSysErrPrintStream(System.err);
        int res = ToolRunner.run(cli, args);
        cli.stop();
        System.exit(res);
    }

    @Override
    public int run(String[] args) throws Exception {
        Options opts = new Options();
        String title = null;
        if (args.length > 0 && args[0].equalsIgnoreCase(APPLICATION)) {
            title = APPLICATION;
            opts.addOption("status", true, "Prints the status of the application.");
            opts.addOption("list", false, "List applications. Supports optional use of -appTypes to filter applications based on application type, -appStates to filter applications based on application state and -appTags to filter applications based on application tag.");
            opts.addOption("movetoqueue", true, "Moves the application to a different queue. Deprecated command. Use 'changeQueue' instead.");
            opts.addOption(QUEUE_CMD, true, "Works with the movetoqueue command to specify which queue to move an application to.");
            opts.addOption("help", false, "Displays help for all commands.");
            Option appTypeOpt = new Option(APP_TYPE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application types.");
            appTypeOpt.setValueSeparator(',');
            appTypeOpt.setArgs(-2);
            appTypeOpt.setArgName("Types");
            opts.addOption(appTypeOpt);
            Option appStateOpt = new Option(APP_STATE_CMD, true, "Works with -list to filter applications based on input comma-separated list of application states. " + this.getAllValidApplicationStates());
            appStateOpt.setValueSeparator(',');
            appStateOpt.setArgs(-2);
            appStateOpt.setArgName("States");
            opts.addOption(appStateOpt);
            Option appTagOpt = new Option(APP_TAG_CMD, true, "Works with -list to filter applications based on input comma-separated list of application tags.");
            appTagOpt.setValueSeparator(',');
            appTagOpt.setArgs(-2);
            appTagOpt.setArgName("Tags");
            opts.addOption(appTagOpt);
            opts.addOption(APP_ID, true, "Specify Application Id to be operated");
            opts.addOption(UPDATE_PRIORITY, true, "update priority of an application. ApplicationId can be passed using 'appId' option.");
            opts.addOption(UPDATE_LIFETIME, true, "update timeout of an application from NOW. ApplicationId can be passed using 'appId' option. Timeout value is in seconds.");
            opts.addOption(CHANGE_APPLICATION_QUEUE, true, "Moves application to a new queue. ApplicationId can be passed using 'appId' option. 'movetoqueue' command is deprecated, this new command 'changeQueue' performs same functionality.");
            Option killOpt = new Option("kill", true, "Kills the application. Set of applications can be provided separated with space");
            killOpt.setValueSeparator(' ');
            killOpt.setArgs(-2);
            killOpt.setArgName("Application ID");
            opts.addOption(killOpt);
            opts.getOption("movetoqueue").setArgName("Application ID");
            opts.getOption(QUEUE_CMD).setArgName("Queue Name");
            opts.getOption("status").setArgName("Application ID");
            opts.getOption(APP_ID).setArgName("Application ID");
            opts.getOption(UPDATE_PRIORITY).setArgName("Priority");
            opts.getOption(UPDATE_LIFETIME).setArgName("Timeout");
            opts.getOption(CHANGE_APPLICATION_QUEUE).setArgName("Queue Name");
        } else if (args.length > 0 && args[0].equalsIgnoreCase(APPLICATION_ATTEMPT)) {
            title = APPLICATION_ATTEMPT;
            opts.addOption("status", true, "Prints the status of the application attempt.");
            opts.addOption("list", true, "List application attempts for application.");
            opts.addOption("fail", true, "Fails application attempt.");
            opts.addOption("help", false, "Displays help for all commands.");
            opts.getOption("status").setArgName("Application Attempt ID");
            opts.getOption("list").setArgName("Application ID");
            opts.getOption("fail").setArgName("Application Attempt ID");
        } else if (args.length > 0 && args[0].equalsIgnoreCase(CONTAINER)) {
            title = CONTAINER;
            opts.addOption("status", true, "Prints the status of the container.");
            opts.addOption("list", true, "List containers for application attempt.");
            opts.addOption("help", false, "Displays help for all commands.");
            opts.getOption("status").setArgName("Container ID");
            opts.getOption("list").setArgName("Application Attempt ID");
            opts.addOption("signal", true, "Signal the container. The available signal commands are " + Arrays.asList(SignalContainerCommand.values()) + " Default command is OUTPUT_THREAD_DUMP.");
            opts.getOption("signal").setArgName("container ID [signal command]");
            opts.getOption("signal").setArgs(3);
        }
        int exitCode = -1;
        CommandLine cliParser = null;
        try {
            cliParser = new GnuParser().parse(opts, args);
        }
        catch (MissingArgumentException ex) {
            this.sysout.println("Missing argument for options");
            this.printUsage(title, opts);
            return exitCode;
        }
        if (cliParser.hasOption("status")) {
            if (args.length != 3) {
                this.printUsage(title, opts);
                return exitCode;
            }
            if (args[0].equalsIgnoreCase(APPLICATION)) {
                exitCode = this.printApplicationReport(cliParser.getOptionValue("status"));
            } else if (args[0].equalsIgnoreCase(APPLICATION_ATTEMPT)) {
                exitCode = this.printApplicationAttemptReport(cliParser.getOptionValue("status"));
            } else if (args[0].equalsIgnoreCase(CONTAINER)) {
                exitCode = this.printContainerReport(cliParser.getOptionValue("status"));
            }
            return exitCode;
        }
        if (cliParser.hasOption("list")) {
            if (args[0].equalsIgnoreCase(APPLICATION)) {
                String[] tags;
                String[] states;
                String[] types;
                this.allAppStates = false;
                HashSet<String> appTypes = new HashSet<String>();
                if (cliParser.hasOption(APP_TYPE_CMD) && (types = cliParser.getOptionValues(APP_TYPE_CMD)) != null) {
                    for (String type : types) {
                        if (type.trim().isEmpty()) continue;
                        appTypes.add(StringUtils.toUpperCase(type).trim());
                    }
                }
                EnumSet<YarnApplicationState> appStates = EnumSet.noneOf(YarnApplicationState.class);
                if (cliParser.hasOption(APP_STATE_CMD) && (states = cliParser.getOptionValues(APP_STATE_CMD)) != null) {
                    for (String state : states) {
                        if (state.trim().isEmpty()) continue;
                        if (state.trim().equalsIgnoreCase(ALLSTATES_OPTION)) {
                            this.allAppStates = true;
                            break;
                        }
                        try {
                            appStates.add(YarnApplicationState.valueOf(StringUtils.toUpperCase(state).trim()));
                        }
                        catch (IllegalArgumentException ex) {
                            this.sysout.println("The application state " + state + " is invalid.");
                            this.sysout.println(this.getAllValidApplicationStates());
                            return exitCode;
                        }
                    }
                }
                HashSet<String> appTags = new HashSet<String>();
                if (cliParser.hasOption(APP_TAG_CMD) && (tags = cliParser.getOptionValues(APP_TAG_CMD)) != null) {
                    for (String tag : tags) {
                        if (tag.trim().isEmpty()) continue;
                        appTags.add(tag.trim());
                    }
                }
                this.listApplications(appTypes, appStates, appTags);
            } else if (args[0].equalsIgnoreCase(APPLICATION_ATTEMPT)) {
                if (args.length != 3) {
                    this.printUsage(title, opts);
                    return exitCode;
                }
                this.listApplicationAttempts(cliParser.getOptionValue("list"));
            } else if (args[0].equalsIgnoreCase(CONTAINER)) {
                if (args.length != 3) {
                    this.printUsage(title, opts);
                    return exitCode;
                }
                this.listContainers(cliParser.getOptionValue("list"));
            }
        } else {
            if (cliParser.hasOption("kill")) {
                if (args.length < 3 || this.hasAnyOtherCLIOptions(cliParser, opts, "kill")) {
                    this.printUsage(title, opts);
                    return exitCode;
                }
                return this.killApplication(cliParser.getOptionValues("kill"));
            }
            if (cliParser.hasOption("movetoqueue")) {
                if (!cliParser.hasOption(QUEUE_CMD)) {
                    this.printUsage(title, opts);
                    return exitCode;
                }
                this.moveApplicationAcrossQueues(cliParser.getOptionValue("movetoqueue"), cliParser.getOptionValue(QUEUE_CMD));
            } else if (cliParser.hasOption("fail")) {
                if (!args[0].equalsIgnoreCase(APPLICATION_ATTEMPT)) {
                    this.printUsage(title, opts);
                    return exitCode;
                }
                this.failApplicationAttempt(cliParser.getOptionValue("fail"));
            } else {
                if (cliParser.hasOption("help")) {
                    this.printUsage(title, opts);
                    return 0;
                }
                if (cliParser.hasOption(UPDATE_PRIORITY)) {
                    if (!cliParser.hasOption(APP_ID)) {
                        this.printUsage(title, opts);
                        return exitCode;
                    }
                    this.updateApplicationPriority(cliParser.getOptionValue(APP_ID), cliParser.getOptionValue(UPDATE_PRIORITY));
                } else if (cliParser.hasOption(UPDATE_LIFETIME)) {
                    if (!cliParser.hasOption(APP_ID)) {
                        this.printUsage(title, opts);
                        return exitCode;
                    }
                    long timeoutInSec = Long.parseLong(cliParser.getOptionValue(UPDATE_LIFETIME));
                    this.updateApplicationTimeout(cliParser.getOptionValue(APP_ID), ApplicationTimeoutType.LIFETIME, timeoutInSec);
                } else if (cliParser.hasOption(CHANGE_APPLICATION_QUEUE)) {
                    if (!cliParser.hasOption(APP_ID)) {
                        this.printUsage(title, opts);
                        return exitCode;
                    }
                    this.moveApplicationAcrossQueues(cliParser.getOptionValue(APP_ID), cliParser.getOptionValue(CHANGE_APPLICATION_QUEUE));
                } else if (cliParser.hasOption("signal")) {
                    if (args.length < 3 || args.length > 4) {
                        this.printUsage(title, opts);
                        return exitCode;
                    }
                    String[] signalArgs = cliParser.getOptionValues("signal");
                    String containerId = signalArgs[0];
                    SignalContainerCommand command = SignalContainerCommand.OUTPUT_THREAD_DUMP;
                    if (signalArgs.length == 2) {
                        command = SignalContainerCommand.valueOf(signalArgs[1]);
                    }
                    this.signalToContainer(containerId, command);
                } else {
                    this.syserr.println("Invalid Command Usage : ");
                    this.printUsage(title, opts);
                }
            }
        }
        return 0;
    }

    private void updateApplicationTimeout(String applicationId, ApplicationTimeoutType timeoutType, long timeoutInSec) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString(applicationId);
        String newTimeout = Times.formatISO8601(System.currentTimeMillis() + timeoutInSec * 1000L);
        this.sysout.println("Updating timeout for given timeoutType: " + timeoutType.toString() + " of an application " + applicationId);
        UpdateApplicationTimeoutsRequest request = UpdateApplicationTimeoutsRequest.newInstance(appId, Collections.singletonMap(timeoutType, newTimeout));
        UpdateApplicationTimeoutsResponse updateApplicationTimeouts = this.client.updateApplicationTimeouts(request);
        String updatedTimeout = updateApplicationTimeouts.getApplicationTimeouts().get((Object)timeoutType);
        if (timeoutType.equals((Object)ApplicationTimeoutType.LIFETIME) && !newTimeout.equals(updatedTimeout)) {
            this.sysout.println("Updated lifetime of an application  " + applicationId + " to queue max/default lifetime. New expiry time is " + updatedTimeout);
            return;
        }
        this.sysout.println("Successfully updated " + timeoutType.toString() + " of an application " + applicationId + ". New expiry time is " + updatedTimeout);
    }

    private void signalToContainer(String containerIdStr, SignalContainerCommand command) throws YarnException, IOException {
        ContainerId containerId = ContainerId.fromString(containerIdStr);
        this.sysout.println("Signalling container " + containerIdStr);
        this.client.signalToContainer(containerId, command);
    }

    @VisibleForTesting
    void printUsage(String title, Options opts) {
        new HelpFormatter().printHelp(title, opts);
    }

    private int printApplicationAttemptReport(String applicationAttemptId) throws YarnException, IOException {
        ApplicationAttemptReport appAttemptReport = null;
        try {
            appAttemptReport = this.client.getApplicationAttemptReport(ApplicationAttemptId.fromString(applicationAttemptId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application for AppAttempt with id '" + applicationAttemptId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.sysout.println("Application Attempt with id '" + applicationAttemptId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter appAttemptReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (appAttemptReport == null) {
            appAttemptReportStr.print("Application Attempt with id '" + applicationAttemptId + "' doesn't exist in Timeline Server.");
            appAttemptReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        appAttemptReportStr.println("Application Attempt Report : ");
        appAttemptReportStr.print("\tApplicationAttempt-Id : ");
        appAttemptReportStr.println(appAttemptReport.getApplicationAttemptId());
        appAttemptReportStr.print("\tState : ");
        appAttemptReportStr.println((Object)appAttemptReport.getYarnApplicationAttemptState());
        appAttemptReportStr.print("\tAMContainer : ");
        appAttemptReportStr.println(appAttemptReport.getAMContainerId() == null ? "N/A" : appAttemptReport.getAMContainerId().toString());
        appAttemptReportStr.print("\tTracking-URL : ");
        appAttemptReportStr.println(appAttemptReport.getTrackingUrl());
        appAttemptReportStr.print("\tRPC Port : ");
        appAttemptReportStr.println(appAttemptReport.getRpcPort());
        appAttemptReportStr.print("\tAM Host : ");
        appAttemptReportStr.println(appAttemptReport.getHost());
        appAttemptReportStr.print("\tDiagnostics : ");
        appAttemptReportStr.print(appAttemptReport.getDiagnostics());
        appAttemptReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private int printContainerReport(String containerId) throws YarnException, IOException {
        ContainerReport containerReport = null;
        try {
            containerReport = this.client.getContainerReport(ContainerId.fromString(containerId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application for Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ApplicationAttemptNotFoundException e) {
            this.sysout.println("Application Attempt for Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        catch (ContainerNotFoundException e) {
            this.sysout.println("Container with id '" + containerId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter containerReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (containerReport == null) {
            containerReportStr.print("Container with id '" + containerId + "' doesn't exist in Timeline Server.");
            containerReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        containerReportStr.println("Container Report : ");
        containerReportStr.print("\tContainer-Id : ");
        containerReportStr.println(containerReport.getContainerId());
        containerReportStr.print("\tStart-Time : ");
        containerReportStr.println(containerReport.getCreationTime());
        containerReportStr.print("\tFinish-Time : ");
        containerReportStr.println(containerReport.getFinishTime());
        containerReportStr.print("\tState : ");
        containerReportStr.println((Object)containerReport.getContainerState());
        containerReportStr.print("\tLOG-URL : ");
        containerReportStr.println(containerReport.getLogUrl());
        containerReportStr.print("\tHost : ");
        containerReportStr.println(containerReport.getAssignedNode());
        containerReportStr.print("\tNodeHttpAddress : ");
        containerReportStr.println(containerReport.getNodeHttpAddress() == null ? "N/A" : containerReport.getNodeHttpAddress());
        containerReportStr.print("\tDiagnostics : ");
        containerReportStr.print(containerReport.getDiagnosticsInfo());
        containerReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private void listApplications(Set<String> appTypes, EnumSet<YarnApplicationState> appStates, Set<String> appTags) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        if (this.allAppStates) {
            for (YarnApplicationState appState : YarnApplicationState.values()) {
                appStates.add(appState);
            }
        } else if (appStates.isEmpty()) {
            appStates.add(YarnApplicationState.RUNNING);
            appStates.add(YarnApplicationState.ACCEPTED);
            appStates.add(YarnApplicationState.SUBMITTED);
        }
        List<ApplicationReport> appsReport = this.client.getApplications(appTypes, appStates, appTags);
        writer.println("Total number of applications (application-types: " + appTypes + ", states: " + appStates + " and tags: " + appTags + "):" + appsReport.size());
        writer.printf(APPLICATIONS_PATTERN, "Application-Id", "Application-Name", "Application-Type", "User", "Queue", "State", "Final-State", "Progress", "Tracking-URL");
        for (ApplicationReport appReport : appsReport) {
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            writer.printf(APPLICATIONS_PATTERN, new Object[]{appReport.getApplicationId(), appReport.getName(), appReport.getApplicationType(), appReport.getUser(), appReport.getQueue(), appReport.getYarnApplicationState(), appReport.getFinalApplicationStatus(), progress, appReport.getOriginalTrackingUrl()});
        }
        writer.flush();
    }

    private int killApplication(String[] applicationIds) throws YarnException, IOException {
        int returnCode = -1;
        for (String applicationId : applicationIds) {
            try {
                this.killApplication(applicationId);
                returnCode = 0;
            }
            catch (ApplicationNotFoundException e) {
                // empty catch block
            }
        }
        return returnCode;
    }

    private void killApplication(String applicationId) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString(applicationId);
        ApplicationReport appReport = null;
        try {
            appReport = this.client.getApplicationReport(appId);
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application with id '" + applicationId + "' doesn't exist in RM.");
            throw e;
        }
        if (appReport.getYarnApplicationState() == YarnApplicationState.FINISHED || appReport.getYarnApplicationState() == YarnApplicationState.KILLED || appReport.getYarnApplicationState() == YarnApplicationState.FAILED) {
            this.sysout.println("Application " + applicationId + " has already finished ");
        } else {
            this.sysout.println("Killing application " + applicationId);
            this.client.killApplication(appId);
        }
    }

    private void moveApplicationAcrossQueues(String applicationId, String queue) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString(applicationId);
        ApplicationReport appReport = this.client.getApplicationReport(appId);
        if (appReport.getYarnApplicationState() == YarnApplicationState.FINISHED || appReport.getYarnApplicationState() == YarnApplicationState.KILLED || appReport.getYarnApplicationState() == YarnApplicationState.FAILED) {
            this.sysout.println("Application " + applicationId + " has already finished ");
        } else {
            this.sysout.println("Moving application " + applicationId + " to queue " + queue);
            this.client.moveApplicationAcrossQueues(appId, queue);
            this.sysout.println("Successfully completed move.");
        }
    }

    private void failApplicationAttempt(String attemptId) throws YarnException, IOException {
        ApplicationAttemptId attId = ApplicationAttemptId.fromString(attemptId);
        ApplicationId appId = attId.getApplicationId();
        this.sysout.println("Failing attempt " + attId + " of application " + appId);
        this.client.failApplicationAttempt(attId);
    }

    private int printApplicationReport(String applicationId) throws YarnException, IOException {
        ApplicationReport appReport = null;
        try {
            appReport = this.client.getApplicationReport(ApplicationId.fromString(applicationId));
        }
        catch (ApplicationNotFoundException e) {
            this.sysout.println("Application with id '" + applicationId + "' doesn't exist in RM or Timeline Server.");
            return -1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter appReportStr = new PrintWriter(new OutputStreamWriter((OutputStream)baos, Charset.forName("UTF-8")));
        if (appReport != null) {
            appReportStr.println("Application Report : ");
            appReportStr.print("\tApplication-Id : ");
            appReportStr.println(appReport.getApplicationId());
            appReportStr.print("\tApplication-Name : ");
            appReportStr.println(appReport.getName());
            appReportStr.print("\tApplication-Type : ");
            appReportStr.println(appReport.getApplicationType());
            appReportStr.print("\tUser : ");
            appReportStr.println(appReport.getUser());
            appReportStr.print("\tQueue : ");
            appReportStr.println(appReport.getQueue());
            appReportStr.print("\tApplication Priority : ");
            appReportStr.println(appReport.getPriority());
            appReportStr.print("\tStart-Time : ");
            appReportStr.println(appReport.getStartTime());
            appReportStr.print("\tFinish-Time : ");
            appReportStr.println(appReport.getFinishTime());
            appReportStr.print("\tProgress : ");
            DecimalFormat formatter = new DecimalFormat("###.##%");
            String progress = formatter.format(appReport.getProgress());
            appReportStr.println(progress);
            appReportStr.print("\tState : ");
            appReportStr.println((Object)appReport.getYarnApplicationState());
            appReportStr.print("\tFinal-State : ");
            appReportStr.println((Object)appReport.getFinalApplicationStatus());
            appReportStr.print("\tTracking-URL : ");
            appReportStr.println(appReport.getOriginalTrackingUrl());
            appReportStr.print("\tRPC Port : ");
            appReportStr.println(appReport.getRpcPort());
            appReportStr.print("\tAM Host : ");
            appReportStr.println(appReport.getHost());
            ApplicationResourceUsageReport usageReport = appReport.getApplicationResourceUsageReport();
            this.printResourceUsage(appReportStr, usageReport);
            appReportStr.print("\tLog Aggregation Status : ");
            appReportStr.println(appReport.getLogAggregationStatus() == null ? "N/A" : appReport.getLogAggregationStatus());
            appReportStr.print("\tDiagnostics : ");
            appReportStr.println(appReport.getDiagnostics());
            appReportStr.print("\tUnmanaged Application : ");
            appReportStr.println(appReport.isUnmanagedApp());
            appReportStr.print("\tApplication Node Label Expression : ");
            appReportStr.println(appReport.getAppNodeLabelExpression());
            appReportStr.print("\tAM container Node Label Expression : ");
            appReportStr.println(appReport.getAmNodeLabelExpression());
            for (ApplicationTimeout timeout : appReport.getApplicationTimeouts().values()) {
                appReportStr.print("\tTimeoutType : " + (Object)((Object)timeout.getTimeoutType()));
                appReportStr.print("\tExpiryTime : " + timeout.getExpiryTime());
                appReportStr.println("\tRemainingTime : " + timeout.getRemainingTime() + "seconds");
            }
        } else {
            appReportStr.print("Application with id '" + applicationId + "' doesn't exist in RM.");
            appReportStr.close();
            this.sysout.println(baos.toString("UTF-8"));
            return -1;
        }
        appReportStr.close();
        this.sysout.println(baos.toString("UTF-8"));
        return 0;
    }

    private void printResourceUsage(PrintWriter appReportStr, ApplicationResourceUsageReport usageReport) {
        appReportStr.print("\tAggregate Resource Allocation : ");
        if (usageReport != null) {
            appReportStr.println(StringHelper.getResourceSecondsString(usageReport.getResourceSecondsMap()));
            appReportStr.print("\tAggregate Resource Preempted : ");
            appReportStr.println(StringHelper.getResourceSecondsString(usageReport.getPreemptedResourceSecondsMap()));
        } else {
            appReportStr.println("N/A");
            appReportStr.print("\tAggregate Resource Preempted : ");
            appReportStr.println("N/A");
        }
    }

    private String getAllValidApplicationStates() {
        StringBuilder sb = new StringBuilder();
        sb.append("The valid application state can be one of the following: ");
        sb.append("ALL,");
        for (YarnApplicationState appState : YarnApplicationState.values()) {
            sb.append((Object)((Object)appState) + ",");
        }
        String output = sb.toString();
        return output.substring(0, output.length() - 1);
    }

    private void listApplicationAttempts(String applicationId) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<ApplicationAttemptReport> appAttemptsReport = this.client.getApplicationAttempts(ApplicationId.fromString(applicationId));
        writer.println("Total number of application attempts :" + appAttemptsReport.size());
        writer.printf(APPLICATION_ATTEMPTS_PATTERN, "ApplicationAttempt-Id", "State", "AM-Container-Id", "Tracking-URL");
        for (ApplicationAttemptReport appAttemptReport : appAttemptsReport) {
            writer.printf(APPLICATION_ATTEMPTS_PATTERN, new Object[]{appAttemptReport.getApplicationAttemptId(), appAttemptReport.getYarnApplicationAttemptState(), appAttemptReport.getAMContainerId() == null ? "N/A" : appAttemptReport.getAMContainerId().toString(), appAttemptReport.getTrackingUrl()});
        }
        writer.flush();
    }

    private void listContainers(String appAttemptId) throws YarnException, IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.sysout, Charset.forName("UTF-8")));
        List<ContainerReport> appsReport = this.client.getContainers(ApplicationAttemptId.fromString(appAttemptId));
        writer.println("Total number of containers :" + appsReport.size());
        writer.printf(CONTAINER_PATTERN, "Container-Id", "Start Time", "Finish Time", "State", "Host", "Node Http Address", "LOG-URL");
        for (ContainerReport containerReport : appsReport) {
            writer.printf(CONTAINER_PATTERN, new Object[]{containerReport.getContainerId(), Times.format(containerReport.getCreationTime()), Times.format(containerReport.getFinishTime()), containerReport.getContainerState(), containerReport.getAssignedNode(), containerReport.getNodeHttpAddress() == null ? "N/A" : containerReport.getNodeHttpAddress(), containerReport.getLogUrl()});
        }
        writer.flush();
    }

    private void updateApplicationPriority(String applicationId, String priority) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.fromString(applicationId);
        Priority newAppPriority = Priority.newInstance(Integer.parseInt(priority));
        this.sysout.println("Updating priority of an application " + applicationId);
        Priority updateApplicationPriority = this.client.updateApplicationPriority(appId, newAppPriority);
        if (newAppPriority.equals(updateApplicationPriority)) {
            this.sysout.println("Successfully updated the application " + applicationId + " with priority '" + priority + "'");
        } else {
            this.sysout.println("Updated priority of an application  " + applicationId + " to cluster max priority OR keeping old priority as application is in final states");
        }
    }

    private boolean hasAnyOtherCLIOptions(CommandLine cliParser, Options opts, String excludeOption) {
        Collection<Option> ops = opts.getOptions();
        for (Option op : ops) {
            if (op.getOpt().equals(excludeOption) || !cliParser.hasOption(op.getOpt())) continue;
            return true;
        }
        return false;
    }
}

