/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import com.google.protobuf.TextFormat;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceUtilization;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourceUtilizationPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NodeReportPBImpl
extends NodeReport {
    private YarnProtos.NodeReportProto proto = YarnProtos.NodeReportProto.getDefaultInstance();
    private YarnProtos.NodeReportProto.Builder builder = null;
    private boolean viaProto = false;
    private NodeId nodeId;
    private Resource used;
    private Resource capability;
    private ResourceUtilization containersUtilization = null;
    private ResourceUtilization nodeUtilization = null;
    Set<String> labels;

    public NodeReportPBImpl() {
        this.builder = YarnProtos.NodeReportProto.newBuilder();
    }

    public NodeReportPBImpl(YarnProtos.NodeReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    @Override
    public Resource getCapability() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.capability != null) {
            return this.capability;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasCapability()) {
            return null;
        }
        this.capability = this.convertFromProtoFormat(p.getCapability());
        return this.capability;
    }

    @Override
    public String getHealthReport() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getHealthReport();
    }

    @Override
    public void setHealthReport(String healthReport) {
        this.maybeInitBuilder();
        if (healthReport == null) {
            this.builder.clearHealthReport();
            return;
        }
        this.builder.setHealthReport(healthReport);
    }

    @Override
    public long getLastHealthReportTime() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getLastHealthReportTime();
    }

    @Override
    public void setLastHealthReportTime(long lastHealthReportTime) {
        this.maybeInitBuilder();
        this.builder.setLastHealthReportTime(lastHealthReportTime);
    }

    @Override
    public String getHttpAddress() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasHttpAddress() ? p.getHttpAddress() : null;
    }

    @Override
    public int getNumContainers() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasNumContainers() ? p.getNumContainers() : 0;
    }

    @Override
    public String getRackName() {
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.hasRackName() ? p.getRackName() : null;
    }

    @Override
    public Resource getUsed() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.used != null) {
            return this.used;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasUsed()) {
            return null;
        }
        this.used = this.convertFromProtoFormat(p.getUsed());
        return this.used;
    }

    @Override
    public NodeId getNodeId() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public NodeState getNodeState() {
        YarnProtos.NodeReportProtoOrBuilder p;
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeState()) {
            return null;
        }
        return ProtoUtils.convertFromProtoFormat(p.getNodeState());
    }

    @Override
    public void setNodeState(NodeState nodeState) {
        this.maybeInitBuilder();
        if (nodeState == null) {
            this.builder.clearNodeState();
            return;
        }
        this.builder.setNodeState(ProtoUtils.convertToProtoFormat(nodeState));
    }

    @Override
    public void setCapability(Resource capability) {
        this.maybeInitBuilder();
        if (capability == null) {
            this.builder.clearCapability();
        }
        this.capability = capability;
    }

    @Override
    public void setHttpAddress(String httpAddress) {
        this.maybeInitBuilder();
        if (httpAddress == null) {
            this.builder.clearHttpAddress();
            return;
        }
        this.builder.setHttpAddress(httpAddress);
    }

    @Override
    public void setNumContainers(int numContainers) {
        this.maybeInitBuilder();
        if (numContainers == 0) {
            this.builder.clearNumContainers();
            return;
        }
        this.builder.setNumContainers(numContainers);
    }

    @Override
    public void setRackName(String rackName) {
        this.maybeInitBuilder();
        if (rackName == null) {
            this.builder.clearRackName();
            return;
        }
        this.builder.setRackName(rackName);
    }

    @Override
    public void setUsed(Resource used) {
        this.maybeInitBuilder();
        if (used == null) {
            this.builder.clearUsed();
        }
        this.used = used;
    }

    public YarnProtos.NodeReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((NodeReportPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.nodeId != null && !((NodeIdPBImpl)this.nodeId).getProto().equals(this.builder.getNodeId())) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.used != null) {
            this.builder.setUsed(this.convertToProtoFormat(this.used));
        }
        if (this.capability != null) {
            this.builder.setCapability(this.convertToProtoFormat(this.capability));
        }
        if (this.labels != null) {
            this.builder.clearNodeLabels();
            this.builder.addAllNodeLabels(this.labels);
        }
        if (this.nodeUtilization != null && !((ResourceUtilizationPBImpl)this.nodeUtilization).getProto().equals(this.builder.getNodeUtilization())) {
            this.builder.setNodeUtilization(this.convertToProtoFormat(this.nodeUtilization));
        }
        if (this.containersUtilization != null && !((ResourceUtilizationPBImpl)this.containersUtilization).getProto().equals(this.builder.getContainersUtilization())) {
            this.builder.setContainersUtilization(this.convertToProtoFormat(this.containersUtilization));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.NodeReportProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId nodeId) {
        return ((NodeIdPBImpl)nodeId).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource r) {
        return ProtoUtils.convertToProtoFormat(r);
    }

    private ResourceUtilizationPBImpl convertFromProtoFormat(YarnProtos.ResourceUtilizationProto p) {
        return new ResourceUtilizationPBImpl(p);
    }

    private YarnProtos.ResourceUtilizationProto convertToProtoFormat(ResourceUtilization r) {
        return ((ResourceUtilizationPBImpl)r).getProto();
    }

    @Override
    public Set<String> getNodeLabels() {
        this.initNodeLabels();
        return this.labels;
    }

    @Override
    public void setNodeLabels(Set<String> nodeLabels) {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        this.labels = nodeLabels;
    }

    private void initNodeLabels() {
        if (this.labels != null) {
            return;
        }
        YarnProtos.NodeReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        this.labels = new HashSet<String>();
        this.labels.addAll(p.getNodeLabelsList());
    }

    @Override
    public ResourceUtilization getAggregatedContainersUtilization() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.containersUtilization != null) {
            return this.containersUtilization;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasContainersUtilization()) {
            return null;
        }
        this.containersUtilization = this.convertFromProtoFormat(p.getContainersUtilization());
        return this.containersUtilization;
    }

    @Override
    public void setAggregatedContainersUtilization(ResourceUtilization containersResourceUtilization) {
        this.maybeInitBuilder();
        if (containersResourceUtilization == null) {
            this.builder.clearContainersUtilization();
        }
        this.containersUtilization = containersResourceUtilization;
    }

    @Override
    public ResourceUtilization getNodeUtilization() {
        YarnProtos.NodeReportProtoOrBuilder p;
        if (this.nodeUtilization != null) {
            return this.nodeUtilization;
        }
        YarnProtos.NodeReportProtoOrBuilder nodeReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeUtilization()) {
            return null;
        }
        this.nodeUtilization = this.convertFromProtoFormat(p.getNodeUtilization());
        return this.nodeUtilization;
    }

    @Override
    public void setNodeUtilization(ResourceUtilization nodeResourceUtilization) {
        this.maybeInitBuilder();
        if (nodeResourceUtilization == null) {
            this.builder.clearNodeUtilization();
        }
        this.nodeUtilization = nodeResourceUtilization;
    }
}

