/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DatanodeInfo
extends DatanodeID
implements Node {
    private long capacity;
    private long dfsUsed;
    private long nonDfsUsed;
    private long remaining;
    private long blockPoolUsed;
    private long cacheCapacity;
    private long cacheUsed;
    private long lastUpdate;
    private long lastUpdateMonotonic;
    private int xceiverCount;
    private volatile String location = "/default-rack";
    private String softwareVersion;
    private List<String> dependentHostNames = new LinkedList<String>();
    private String upgradeDomain;
    public static final DatanodeInfo[] EMPTY_ARRAY = new DatanodeInfo[0];
    protected AdminStates adminState;
    private long maintenanceExpireTimeInMS;
    private long lastBlockReportTime;
    private long lastBlockReportMonotonic;
    private transient int level;
    private transient Node parent;

    protected DatanodeInfo(DatanodeInfo from) {
        super(from);
        this.capacity = from.getCapacity();
        this.dfsUsed = from.getDfsUsed();
        this.nonDfsUsed = from.getNonDfsUsed();
        this.remaining = from.getRemaining();
        this.blockPoolUsed = from.getBlockPoolUsed();
        this.cacheCapacity = from.getCacheCapacity();
        this.cacheUsed = from.getCacheUsed();
        this.lastUpdate = from.getLastUpdate();
        this.lastUpdateMonotonic = from.getLastUpdateMonotonic();
        this.xceiverCount = from.getXceiverCount();
        this.location = from.getNetworkLocation();
        this.adminState = from.getAdminState();
        this.upgradeDomain = from.getUpgradeDomain();
        this.lastBlockReportTime = from.getLastBlockReportTime();
        this.lastBlockReportMonotonic = from.getLastBlockReportMonotonic();
    }

    protected DatanodeInfo(DatanodeID nodeID) {
        super(nodeID);
        this.capacity = 0L;
        this.dfsUsed = 0L;
        this.nonDfsUsed = 0L;
        this.remaining = 0L;
        this.blockPoolUsed = 0L;
        this.cacheCapacity = 0L;
        this.cacheUsed = 0L;
        this.lastUpdate = 0L;
        this.lastUpdateMonotonic = 0L;
        this.xceiverCount = 0;
        this.adminState = null;
        this.lastBlockReportTime = 0L;
        this.lastBlockReportMonotonic = 0L;
    }

    protected DatanodeInfo(DatanodeID nodeID, String location) {
        this(nodeID);
        this.location = location;
    }

    private DatanodeInfo(String ipAddr, String hostName, String datanodeUuid, int xferPort, int infoPort, int infoSecurePort, int ipcPort, long capacity, long dfsUsed, long nonDfsUsed, long remaining, long blockPoolUsed, long cacheCapacity, long cacheUsed, long lastUpdate, long lastUpdateMonotonic, int xceiverCount, String networkLocation, AdminStates adminState, String upgradeDomain, long lastBlockReportTime, long lastBlockReportMonotonic) {
        super(ipAddr, hostName, datanodeUuid, xferPort, infoPort, infoSecurePort, ipcPort);
        this.capacity = capacity;
        this.dfsUsed = dfsUsed;
        this.nonDfsUsed = nonDfsUsed;
        this.remaining = remaining;
        this.blockPoolUsed = blockPoolUsed;
        this.cacheCapacity = cacheCapacity;
        this.cacheUsed = cacheUsed;
        this.lastUpdate = lastUpdate;
        this.lastUpdateMonotonic = lastUpdateMonotonic;
        this.xceiverCount = xceiverCount;
        this.location = networkLocation;
        this.adminState = adminState;
        this.upgradeDomain = upgradeDomain;
        this.lastBlockReportTime = lastBlockReportTime;
        this.lastBlockReportMonotonic = lastBlockReportMonotonic;
    }

    @Override
    public String getName() {
        return this.getXferAddr();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getDfsUsed() {
        return this.dfsUsed;
    }

    public long getBlockPoolUsed() {
        return this.blockPoolUsed;
    }

    public long getNonDfsUsed() {
        return this.nonDfsUsed;
    }

    public float getDfsUsedPercent() {
        return DFSUtilClient.getPercentUsed(this.dfsUsed, this.capacity);
    }

    public long getRemaining() {
        return this.remaining;
    }

    public float getBlockPoolUsedPercent() {
        return DFSUtilClient.getPercentUsed(this.blockPoolUsed, this.capacity);
    }

    public float getRemainingPercent() {
        return DFSUtilClient.getPercentRemaining(this.remaining, this.capacity);
    }

    public long getCacheCapacity() {
        return this.cacheCapacity;
    }

    public long getCacheUsed() {
        return this.cacheUsed;
    }

    public float getCacheUsedPercent() {
        return DFSUtilClient.getPercentUsed(this.cacheUsed, this.cacheCapacity);
    }

    public long getCacheRemaining() {
        return this.cacheCapacity - this.cacheUsed;
    }

    public float getCacheRemainingPercent() {
        return DFSUtilClient.getPercentRemaining(this.getCacheRemaining(), this.cacheCapacity);
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public long getLastUpdateMonotonic() {
        return this.lastUpdateMonotonic;
    }

    public void setLastUpdateMonotonic(long lastUpdateMonotonic) {
        this.lastUpdateMonotonic = lastUpdateMonotonic;
    }

    public int getXceiverCount() {
        return this.xceiverCount;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setDfsUsed(long dfsUsed) {
        this.dfsUsed = dfsUsed;
    }

    public void setNonDfsUsed(long nonDfsUsed) {
        this.nonDfsUsed = nonDfsUsed;
    }

    public void setRemaining(long remaining) {
        this.remaining = remaining;
    }

    public void setBlockPoolUsed(long bpUsed) {
        this.blockPoolUsed = bpUsed;
    }

    public void setCacheCapacity(long cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setCacheUsed(long cacheUsed) {
        this.cacheUsed = cacheUsed;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setXceiverCount(int xceiverCount) {
        this.xceiverCount = xceiverCount;
    }

    @Override
    public String getNetworkLocation() {
        return this.location;
    }

    @Override
    public void setNetworkLocation(String location) {
        this.location = NodeBase.normalize(location);
    }

    public void setUpgradeDomain(String upgradeDomain) {
        this.upgradeDomain = upgradeDomain;
    }

    public String getUpgradeDomain() {
        return this.upgradeDomain;
    }

    public void addDependentHostName(String hostname) {
        this.dependentHostNames.add(hostname);
    }

    public List<String> getDependentHostNames() {
        return this.dependentHostNames;
    }

    public void setDependentHostNames(List<String> dependencyList) {
        this.dependentHostNames = dependencyList;
    }

    public String getDatanodeReport() {
        StringBuilder buffer = new StringBuilder();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        long nonDFSUsed = this.getNonDfsUsed();
        float usedPercent = this.getDfsUsedPercent();
        float remainingPercent = this.getRemainingPercent();
        long cc = this.getCacheCapacity();
        long cr = this.getCacheRemaining();
        long cu = this.getCacheUsed();
        float cacheUsedPercent = this.getCacheUsedPercent();
        float cacheRemainingPercent = this.getCacheRemainingPercent();
        String lookupName = NetUtils.getHostNameOfIP(this.getName());
        buffer.append("Name: ").append(this.getName());
        if (lookupName != null) {
            buffer.append(" (").append(lookupName).append(")");
        }
        buffer.append("\n");
        buffer.append("Hostname: ").append(this.getHostName()).append("\n");
        if (!"/default-rack".equals(this.location)) {
            buffer.append("Rack: ").append(this.location).append("\n");
        }
        if (this.upgradeDomain != null) {
            buffer.append("Upgrade domain: ").append(this.upgradeDomain).append("\n");
        }
        buffer.append("Decommission Status : ");
        if (this.isDecommissioned()) {
            buffer.append("Decommissioned\n");
        } else if (this.isDecommissionInProgress()) {
            buffer.append("Decommission in progress\n");
        } else if (this.isInMaintenance()) {
            buffer.append("In maintenance\n");
        } else if (this.isEnteringMaintenance()) {
            buffer.append("Entering maintenance\n");
        } else {
            buffer.append("Normal\n");
        }
        buffer.append("Configured Capacity: ").append(c).append(" (").append(StringUtils.byteDesc(c)).append(")").append("\n");
        buffer.append("DFS Used: ").append(u).append(" (").append(StringUtils.byteDesc(u)).append(")").append("\n");
        buffer.append("Non DFS Used: ").append(nonDFSUsed).append(" (").append(StringUtils.byteDesc(nonDFSUsed)).append(")").append("\n");
        buffer.append("DFS Remaining: ").append(r).append(" (").append(StringUtils.byteDesc(r)).append(")").append("\n");
        buffer.append("DFS Used%: ").append(DFSUtilClient.percent2String(usedPercent)).append("\n");
        buffer.append("DFS Remaining%: ").append(DFSUtilClient.percent2String(remainingPercent)).append("\n");
        buffer.append("Configured Cache Capacity: ").append(cc).append(" (").append(StringUtils.byteDesc(cc)).append(")").append("\n");
        buffer.append("Cache Used: ").append(cu).append(" (").append(StringUtils.byteDesc(cu)).append(")").append("\n");
        buffer.append("Cache Remaining: ").append(cr).append(" (").append(StringUtils.byteDesc(cr)).append(")").append("\n");
        buffer.append("Cache Used%: ").append(DFSUtilClient.percent2String(cacheUsedPercent)).append("\n");
        buffer.append("Cache Remaining%: ").append(DFSUtilClient.percent2String(cacheRemainingPercent)).append("\n");
        buffer.append("Xceivers: ").append(this.getXceiverCount()).append("\n");
        buffer.append("Last contact: ").append(new Date(this.lastUpdate)).append("\n");
        buffer.append("Last Block Report: ").append(this.lastBlockReportTime != 0L ? new Date(this.lastBlockReportTime) : "Never").append("\n");
        return buffer.toString();
    }

    public String dumpDatanode() {
        StringBuilder buffer = new StringBuilder();
        long c = this.getCapacity();
        long r = this.getRemaining();
        long u = this.getDfsUsed();
        float usedPercent = this.getDfsUsedPercent();
        long cc = this.getCacheCapacity();
        long cr = this.getCacheRemaining();
        long cu = this.getCacheUsed();
        float cacheUsedPercent = this.getCacheUsedPercent();
        buffer.append(this.getName());
        if (!"/default-rack".equals(this.location)) {
            buffer.append(" ").append(this.location);
        }
        if (this.upgradeDomain != null) {
            buffer.append(" ").append(this.upgradeDomain);
        }
        if (this.isDecommissioned()) {
            buffer.append(" DD");
        } else if (this.isDecommissionInProgress()) {
            buffer.append(" DP");
        } else if (this.isInMaintenance()) {
            buffer.append(" IM");
        } else if (this.isEnteringMaintenance()) {
            buffer.append(" EM");
        } else {
            buffer.append(" IN");
        }
        buffer.append(" ").append(c).append("(").append(StringUtils.byteDesc(c)).append(")");
        buffer.append(" ").append(u).append("(").append(StringUtils.byteDesc(u)).append(")");
        buffer.append(" ").append(DFSUtilClient.percent2String(usedPercent));
        buffer.append(" ").append(r).append("(").append(StringUtils.byteDesc(r)).append(")");
        buffer.append(" ").append(cc).append("(").append(StringUtils.byteDesc(cc)).append(")");
        buffer.append(" ").append(cu).append("(").append(StringUtils.byteDesc(cu)).append(")");
        buffer.append(" ").append(DFSUtilClient.percent2String(cacheUsedPercent));
        buffer.append(" ").append(cr).append("(").append(StringUtils.byteDesc(cr)).append(")");
        buffer.append(" ").append(new Date(this.lastUpdate));
        return buffer.toString();
    }

    public void startDecommission() {
        this.adminState = AdminStates.DECOMMISSION_INPROGRESS;
    }

    public void stopDecommission() {
        this.adminState = null;
    }

    public boolean isDecommissionInProgress() {
        return this.adminState == AdminStates.DECOMMISSION_INPROGRESS;
    }

    public boolean isDecommissioned() {
        return this.adminState == AdminStates.DECOMMISSIONED;
    }

    public void setDecommissioned() {
        this.adminState = AdminStates.DECOMMISSIONED;
    }

    public void startMaintenance() {
        this.adminState = AdminStates.ENTERING_MAINTENANCE;
    }

    public void setInMaintenance() {
        this.adminState = AdminStates.IN_MAINTENANCE;
    }

    public void setMaintenanceExpireTimeInMS(long maintenanceExpireTimeInMS) {
        this.maintenanceExpireTimeInMS = maintenanceExpireTimeInMS;
    }

    public long getMaintenanceExpireTimeInMS() {
        return this.maintenanceExpireTimeInMS;
    }

    public void setLastBlockReportTime(long lastBlockReportTime) {
        this.lastBlockReportTime = lastBlockReportTime;
    }

    public void setLastBlockReportMonotonic(long lastBlockReportMonotonic) {
        this.lastBlockReportMonotonic = lastBlockReportMonotonic;
    }

    public long getLastBlockReportTime() {
        return this.lastBlockReportTime;
    }

    public long getLastBlockReportMonotonic() {
        return this.lastBlockReportMonotonic;
    }

    public void stopMaintenance() {
        this.adminState = null;
    }

    public static boolean maintenanceNotExpired(long maintenanceExpireTimeInMS) {
        return Time.now() < maintenanceExpireTimeInMS;
    }

    public boolean isEnteringMaintenance() {
        return this.adminState == AdminStates.ENTERING_MAINTENANCE;
    }

    public boolean isInMaintenance() {
        return this.adminState == AdminStates.IN_MAINTENANCE;
    }

    public boolean isMaintenance() {
        return this.adminState == AdminStates.ENTERING_MAINTENANCE || this.adminState == AdminStates.IN_MAINTENANCE;
    }

    public boolean maintenanceExpired() {
        return !DatanodeInfo.maintenanceNotExpired(this.maintenanceExpireTimeInMS);
    }

    public boolean isInService() {
        return this.getAdminState() == AdminStates.NORMAL;
    }

    public AdminStates getAdminState() {
        if (this.adminState == null) {
            return AdminStates.NORMAL;
        }
        return this.adminState;
    }

    public boolean isStale(long staleInterval) {
        return Time.monotonicNow() - this.lastUpdateMonotonic >= staleInterval;
    }

    protected void setAdminState(AdminStates newState) {
        this.adminState = newState == AdminStates.NORMAL ? null : newState;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public static class DatanodeInfoBuilder {
        private String location = "/default-rack";
        private long capacity;
        private long dfsUsed;
        private long remaining;
        private long blockPoolUsed;
        private long cacheCapacity;
        private long cacheUsed;
        private long lastUpdate;
        private long lastUpdateMonotonic;
        private int xceiverCount;
        private AdminStates adminState;
        private String upgradeDomain;
        private String ipAddr;
        private String hostName;
        private String datanodeUuid;
        private int xferPort;
        private int infoPort;
        private int infoSecurePort;
        private int ipcPort;
        private long nonDfsUsed = 0L;
        private long lastBlockReportTime = 0L;
        private long lastBlockReportMonotonic = 0L;

        public DatanodeInfoBuilder setFrom(DatanodeInfo from) {
            this.capacity = from.getCapacity();
            this.dfsUsed = from.getDfsUsed();
            this.nonDfsUsed = from.getNonDfsUsed();
            this.remaining = from.getRemaining();
            this.blockPoolUsed = from.getBlockPoolUsed();
            this.cacheCapacity = from.getCacheCapacity();
            this.cacheUsed = from.getCacheUsed();
            this.lastUpdate = from.getLastUpdate();
            this.lastUpdateMonotonic = from.getLastUpdateMonotonic();
            this.xceiverCount = from.getXceiverCount();
            this.location = from.getNetworkLocation();
            this.adminState = from.getAdminState();
            this.upgradeDomain = from.getUpgradeDomain();
            this.lastBlockReportTime = from.getLastBlockReportTime();
            this.lastBlockReportMonotonic = from.getLastBlockReportMonotonic();
            this.setNodeID(from);
            return this;
        }

        public DatanodeInfoBuilder setNodeID(DatanodeID nodeID) {
            this.ipAddr = nodeID.getIpAddr();
            this.hostName = nodeID.getHostName();
            this.datanodeUuid = nodeID.getDatanodeUuid();
            this.xferPort = nodeID.getXferPort();
            this.infoPort = nodeID.getInfoPort();
            this.infoSecurePort = nodeID.getInfoSecurePort();
            this.ipcPort = nodeID.getIpcPort();
            return this;
        }

        public DatanodeInfoBuilder setCapacity(long capacity) {
            this.capacity = capacity;
            return this;
        }

        public DatanodeInfoBuilder setDfsUsed(long dfsUsed) {
            this.dfsUsed = dfsUsed;
            return this;
        }

        public DatanodeInfoBuilder setRemaining(long remaining) {
            this.remaining = remaining;
            return this;
        }

        public DatanodeInfoBuilder setBlockPoolUsed(long blockPoolUsed) {
            this.blockPoolUsed = blockPoolUsed;
            return this;
        }

        public DatanodeInfoBuilder setCacheCapacity(long cacheCapacity) {
            this.cacheCapacity = cacheCapacity;
            return this;
        }

        public DatanodeInfoBuilder setCacheUsed(long cacheUsed) {
            this.cacheUsed = cacheUsed;
            return this;
        }

        public DatanodeInfoBuilder setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        public DatanodeInfoBuilder setLastUpdateMonotonic(long lastUpdateMonotonic) {
            this.lastUpdateMonotonic = lastUpdateMonotonic;
            return this;
        }

        public DatanodeInfoBuilder setXceiverCount(int xceiverCount) {
            this.xceiverCount = xceiverCount;
            return this;
        }

        public DatanodeInfoBuilder setAdminState(AdminStates adminState) {
            this.adminState = adminState;
            return this;
        }

        public DatanodeInfoBuilder setUpgradeDomain(String upgradeDomain) {
            this.upgradeDomain = upgradeDomain;
            return this;
        }

        public DatanodeInfoBuilder setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
            return this;
        }

        public DatanodeInfoBuilder setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public DatanodeInfoBuilder setDatanodeUuid(String datanodeUuid) {
            this.datanodeUuid = datanodeUuid;
            return this;
        }

        public DatanodeInfoBuilder setXferPort(int xferPort) {
            this.xferPort = xferPort;
            return this;
        }

        public DatanodeInfoBuilder setInfoPort(int infoPort) {
            this.infoPort = infoPort;
            return this;
        }

        public DatanodeInfoBuilder setInfoSecurePort(int infoSecurePort) {
            this.infoSecurePort = infoSecurePort;
            return this;
        }

        public DatanodeInfoBuilder setIpcPort(int ipcPort) {
            this.ipcPort = ipcPort;
            return this;
        }

        public DatanodeInfoBuilder setNetworkLocation(String networkLocation) {
            this.location = networkLocation;
            return this;
        }

        public DatanodeInfoBuilder setNonDfsUsed(long nonDfsUsed) {
            this.nonDfsUsed = nonDfsUsed;
            return this;
        }

        public DatanodeInfoBuilder setLastBlockReportTime(long time) {
            this.lastBlockReportTime = time;
            return this;
        }

        public DatanodeInfoBuilder setLastBlockReportMonotonic(long time) {
            this.lastBlockReportMonotonic = time;
            return this;
        }

        public DatanodeInfo build() {
            return new DatanodeInfo(this.ipAddr, this.hostName, this.datanodeUuid, this.xferPort, this.infoPort, this.infoSecurePort, this.ipcPort, this.capacity, this.dfsUsed, this.nonDfsUsed, this.remaining, this.blockPoolUsed, this.cacheCapacity, this.cacheUsed, this.lastUpdate, this.lastUpdateMonotonic, this.xceiverCount, this.location, this.adminState, this.upgradeDomain, this.lastBlockReportTime, this.lastBlockReportMonotonic);
        }
    }

    public static enum AdminStates {
        NORMAL("In Service"),
        DECOMMISSION_INPROGRESS("Decommission In Progress"),
        DECOMMISSIONED("Decommissioned"),
        ENTERING_MAINTENANCE("Entering Maintenance"),
        IN_MAINTENANCE("In Maintenance");

        final String value;

        private AdminStates(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }

        public static AdminStates fromValue(String value) {
            for (AdminStates as : AdminStates.values()) {
                if (!as.value.equals(value)) continue;
                return as;
            }
            return NORMAL;
        }
    }
}

