/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.ftp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.ftp.FTPException;
import org.apache.hadoop.fs.ftp.FTPInputStream;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FTPFileSystem
extends FileSystem {
    public static final Logger LOG = LoggerFactory.getLogger(FTPFileSystem.class);
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    public static final long DEFAULT_TIMEOUT = 0L;
    public static final String FS_FTP_USER_PREFIX = "fs.ftp.user.";
    public static final String FS_FTP_HOST = "fs.ftp.host";
    public static final String FS_FTP_HOST_PORT = "fs.ftp.host.port";
    public static final String FS_FTP_PASSWORD_PREFIX = "fs.ftp.password.";
    public static final String FS_FTP_DATA_CONNECTION_MODE = "fs.ftp.data.connection.mode";
    public static final String FS_FTP_TRANSFER_MODE = "fs.ftp.transfer.mode";
    public static final String E_SAME_DIRECTORY_ONLY = "only same directory renames are supported";
    public static final String FS_FTP_TIMEOUT = "fs.ftp.timeout";
    private URI uri;

    @Override
    public String getScheme() {
        return "ftp";
    }

    @Override
    protected int getDefaultPort() {
        return 21;
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException {
        String[] userPasswdInfo;
        super.initialize(uri, conf);
        String host = uri.getHost();
        String string = host = host == null ? conf.get(FS_FTP_HOST, null) : host;
        if (host == null) {
            throw new IOException("Invalid host specified");
        }
        conf.set(FS_FTP_HOST, host);
        int port = uri.getPort();
        port = port == -1 ? 21 : port;
        conf.setInt(FS_FTP_HOST_PORT, port);
        String userAndPassword = uri.getUserInfo();
        if (userAndPassword == null) {
            userAndPassword = conf.get(FS_FTP_USER_PREFIX + host, null) + ":" + conf.get(FS_FTP_PASSWORD_PREFIX + host, null);
        }
        Preconditions.checkState((userPasswdInfo = userAndPassword.split(":")).length > 1, "Invalid username / password");
        conf.set(FS_FTP_USER_PREFIX + host, userPasswdInfo[0]);
        conf.set(FS_FTP_PASSWORD_PREFIX + host, userPasswdInfo[1]);
        this.setConf(conf);
        this.uri = uri;
    }

    private FTPClient connect() throws IOException {
        FTPClient client = null;
        Configuration conf = this.getConf();
        String host = conf.get(FS_FTP_HOST);
        int port = conf.getInt(FS_FTP_HOST_PORT, 21);
        String user = conf.get(FS_FTP_USER_PREFIX + host);
        String password = conf.get(FS_FTP_PASSWORD_PREFIX + host);
        client = new FTPClient();
        client.connect(host, port);
        int reply = client.getReplyCode();
        if (!FTPReply.isPositiveCompletion(reply)) {
            throw NetUtils.wrapException(host, port, "(unknown)", 0, new ConnectException("Server response " + reply));
        }
        if (!client.login(user, password)) {
            throw new IOException("Login failed on server - " + host + ", port - " + port + " as user '" + user + "'");
        }
        client.setFileTransferMode(this.getTransferMode(conf));
        client.setFileType(2);
        client.setBufferSize(0x100000);
        this.setTimeout(client, conf);
        this.setDataConnectionMode(client, conf);
        return client;
    }

    @VisibleForTesting
    void setTimeout(FTPClient client, Configuration conf) {
        long timeout = conf.getLong(FS_FTP_TIMEOUT, 0L);
        client.setControlKeepAliveTimeout(timeout);
    }

    @VisibleForTesting
    int getTransferMode(Configuration conf) {
        String mode = conf.get(FS_FTP_TRANSFER_MODE);
        int ret = 11;
        if (mode == null) {
            return ret;
        }
        String upper = mode.toUpperCase();
        if (upper.equals("STREAM_TRANSFER_MODE")) {
            ret = 10;
        } else if (upper.equals("COMPRESSED_TRANSFER_MODE")) {
            ret = 12;
        } else if (!upper.equals("BLOCK_TRANSFER_MODE")) {
            LOG.warn("Cannot parse the value for fs.ftp.transfer.mode: " + mode + ". Using default.");
        }
        return ret;
    }

    @VisibleForTesting
    void setDataConnectionMode(FTPClient client, Configuration conf) throws IOException {
        String mode = conf.get(FS_FTP_DATA_CONNECTION_MODE);
        if (mode == null) {
            return;
        }
        String upper = mode.toUpperCase();
        if (upper.equals("PASSIVE_LOCAL_DATA_CONNECTION_MODE")) {
            client.enterLocalPassiveMode();
        } else if (upper.equals("PASSIVE_REMOTE_DATA_CONNECTION_MODE")) {
            client.enterRemotePassiveMode();
        } else if (!upper.equals("ACTIVE_LOCAL_DATA_CONNECTION_MODE")) {
            LOG.warn("Cannot parse the value for fs.ftp.data.connection.mode: " + mode + ". Using default.");
        }
    }

    private void disconnect(FTPClient client) throws IOException {
        if (client != null) {
            if (!client.isConnected()) {
                throw new FTPException("Client not connected");
            }
            boolean logoutSuccess = client.logout();
            client.disconnect();
            if (!logoutSuccess) {
                LOG.warn("Logout failed while disconnecting, error code - " + client.getReplyCode());
            }
        }
    }

    private Path makeAbsolute(Path workDir, Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(workDir, path);
    }

    @Override
    public FSDataInputStream open(Path file, int bufferSize) throws IOException {
        Path workDir;
        Path absolute;
        FTPClient client = this.connect();
        FileStatus fileStat = this.getFileStatus(client, absolute = this.makeAbsolute(workDir = new Path(client.printWorkingDirectory()), file));
        if (fileStat.isDirectory()) {
            this.disconnect(client);
            throw new FileNotFoundException("Path " + file + " is a directory.");
        }
        client.allocate(bufferSize);
        Path parent = absolute.getParent();
        client.changeWorkingDirectory(parent.toUri().getPath());
        InputStream is = client.retrieveFileStream(file.getName());
        FSDataInputStream fis = new FSDataInputStream(new FTPInputStream(is, client, this.statistics));
        if (!FTPReply.isPositivePreliminary(client.getReplyCode())) {
            fis.close();
            throw new IOException("Unable to open file: " + file + ", Aborting");
        }
        return fis;
    }

    @Override
    public FSDataOutputStream create(Path file, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parent;
        FileStatus status;
        final FTPClient client = this.connect();
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        try {
            status = this.getFileStatus(client, file);
        }
        catch (FileNotFoundException fnfe) {
            status = null;
        }
        if (status != null) {
            if (overwrite && !status.isDirectory()) {
                this.delete(client, file, false);
            } else {
                this.disconnect(client);
                throw new FileAlreadyExistsException("File already exists: " + file);
            }
        }
        if ((parent = absolute.getParent()) == null || !this.mkdirs(client, parent, FsPermission.getDirDefault())) {
            parent = parent == null ? new Path("/") : parent;
            this.disconnect(client);
            throw new IOException("create(): Mkdirs failed to create: " + parent);
        }
        client.allocate(bufferSize);
        client.changeWorkingDirectory(parent.toUri().getPath());
        FSDataOutputStream fos = new FSDataOutputStream(client.storeFileStream(file.getName()), this.statistics){

            @Override
            public void close() throws IOException {
                super.close();
                if (!client.isConnected()) {
                    throw new FTPException("Client not connected");
                }
                boolean cmdCompleted = client.completePendingCommand();
                FTPFileSystem.this.disconnect(client);
                if (!cmdCompleted) {
                    throw new FTPException("Could not complete transfer, Reply Code - " + client.getReplyCode());
                }
            }
        };
        if (!FTPReply.isPositivePreliminary(client.getReplyCode())) {
            fos.close();
            throw new IOException("Unable to create file: " + file + ", Aborting");
        }
        return fos;
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("Append is not supported by FTPFileSystem");
    }

    private boolean exists(FTPClient client, Path file) throws IOException {
        try {
            this.getFileStatus(client, file);
            return true;
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Path file, boolean recursive) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.delete(client, file, recursive);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean delete(FTPClient client, Path file, boolean recursive) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        String pathName = absolute.toUri().getPath();
        try {
            FileStatus fileStat = this.getFileStatus(client, absolute);
            if (fileStat.isFile()) {
                return client.deleteFile(pathName);
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        FileStatus[] dirEntries = this.listStatus(client, absolute);
        if (dirEntries != null && dirEntries.length > 0 && !recursive) {
            throw new IOException("Directory: " + file + " is not empty.");
        }
        for (FileStatus dirEntry : dirEntries) {
            this.delete(client, new Path(absolute, dirEntry.getPath()), recursive);
        }
        return client.removeDirectory(pathName);
    }

    @VisibleForTesting
    FsAction getFsAction(int accessGroup, FTPFile ftpFile) {
        FsAction action = FsAction.NONE;
        if (ftpFile.hasPermission(accessGroup, 0)) {
            action = action.or(FsAction.READ);
        }
        if (ftpFile.hasPermission(accessGroup, 1)) {
            action = action.or(FsAction.WRITE);
        }
        if (ftpFile.hasPermission(accessGroup, 2)) {
            action = action.or(FsAction.EXECUTE);
        }
        return action;
    }

    private FsPermission getPermissions(FTPFile ftpFile) {
        FsAction user = this.getFsAction(0, ftpFile);
        FsAction group = this.getFsAction(1, ftpFile);
        FsAction others = this.getFsAction(2, ftpFile);
        return new FsPermission(user, group, others);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatus[] listStatus(Path file) throws IOException {
        FTPClient client = this.connect();
        try {
            FileStatus[] stats;
            FileStatus[] fileStatusArray = stats = this.listStatus(client, file);
            return fileStatusArray;
        }
        finally {
            this.disconnect(client);
        }
    }

    private FileStatus[] listStatus(FTPClient client, Path file) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        FileStatus fileStat = this.getFileStatus(client, absolute);
        if (fileStat.isFile()) {
            return new FileStatus[]{fileStat};
        }
        FTPFile[] ftpFiles = client.listFiles(absolute.toUri().getPath());
        FileStatus[] fileStats = new FileStatus[ftpFiles.length];
        for (int i = 0; i < ftpFiles.length; ++i) {
            fileStats[i] = this.getFileStatus(ftpFiles[i], absolute);
        }
        return fileStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileStatus getFileStatus(Path file) throws IOException {
        FTPClient client = this.connect();
        try {
            FileStatus status;
            FileStatus fileStatus = status = this.getFileStatus(client, file);
            return fileStatus;
        }
        finally {
            this.disconnect(client);
        }
    }

    private FileStatus getFileStatus(FTPClient client, Path file) throws IOException {
        FileStatus fileStat = null;
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        Path parentPath = absolute.getParent();
        if (parentPath == null) {
            long length = -1L;
            boolean isDir = true;
            int blockReplication = 1;
            long blockSize = 4096L;
            long modTime = -1L;
            Path root = new Path("/");
            return new FileStatus(length, isDir, blockReplication, blockSize, modTime, this.makeQualified(root));
        }
        String pathName = parentPath.toUri().getPath();
        FTPFile[] ftpFiles = client.listFiles(pathName);
        if (ftpFiles != null) {
            for (FTPFile ftpFile : ftpFiles) {
                if (!ftpFile.getName().equals(file.getName())) continue;
                fileStat = this.getFileStatus(ftpFile, parentPath);
                break;
            }
            if (fileStat == null) {
                throw new FileNotFoundException("File " + file + " does not exist.");
            }
        } else {
            throw new FileNotFoundException("File " + file + " does not exist.");
        }
        return fileStat;
    }

    private FileStatus getFileStatus(FTPFile ftpFile, Path parentPath) {
        long length = ftpFile.getSize();
        boolean isDir = ftpFile.isDirectory();
        int blockReplication = 1;
        long blockSize = 4096L;
        long modTime = ftpFile.getTimestamp().getTimeInMillis();
        long accessTime = 0L;
        FsPermission permission = this.getPermissions(ftpFile);
        String user = ftpFile.getUser();
        String group = ftpFile.getGroup();
        Path filePath = new Path(parentPath, ftpFile.getName());
        return new FileStatus(length, isDir, blockReplication, blockSize, modTime, accessTime, permission, user, group, this.makeQualified(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mkdirs(Path file, FsPermission permission) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.mkdirs(client, file, permission);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean mkdirs(FTPClient client, Path file, FsPermission permission) throws IOException {
        boolean created = true;
        Path workDir = new Path(client.printWorkingDirectory());
        Path absolute = this.makeAbsolute(workDir, file);
        String pathName = absolute.getName();
        if (!this.exists(client, absolute)) {
            Path parent = absolute.getParent();
            boolean bl = created = parent == null || this.mkdirs(client, parent, FsPermission.getDirDefault());
            if (created) {
                String parentDir = parent.toUri().getPath();
                client.changeWorkingDirectory(parentDir);
                created = created && client.makeDirectory(pathName);
            }
        } else if (this.isFile(client, absolute)) {
            throw new ParentNotDirectoryException(String.format("Can't make directory for path %s since it is a file.", absolute));
        }
        return created;
    }

    private boolean isFile(FTPClient client, Path file) {
        try {
            return this.getFileStatus(client, file).isFile();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException ioe) {
            throw new FTPException("File check failed", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        FTPClient client = this.connect();
        try {
            boolean success;
            boolean bl = success = this.rename(client, src, dst);
            return bl;
        }
        finally {
            this.disconnect(client);
        }
    }

    private boolean isParentOf(Path parent, Path child) {
        URI parentURI = parent.toUri();
        String parentPath = parentURI.getPath();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        URI childURI = child.toUri();
        String childPath = childURI.getPath();
        return childPath.startsWith(parentPath);
    }

    private boolean rename(FTPClient client, Path src, Path dst) throws IOException {
        Path workDir = new Path(client.printWorkingDirectory());
        Path absoluteSrc = this.makeAbsolute(workDir, src);
        Path absoluteDst = this.makeAbsolute(workDir, dst);
        if (!this.exists(client, absoluteSrc)) {
            throw new FileNotFoundException("Source path " + src + " does not exist");
        }
        if (this.isDirectory(absoluteDst)) {
            absoluteDst = new Path(absoluteDst, absoluteSrc.getName());
        }
        if (this.exists(client, absoluteDst)) {
            throw new FileAlreadyExistsException("Destination path " + dst + " already exists");
        }
        String parentSrc = absoluteSrc.getParent().toUri().toString();
        String parentDst = absoluteDst.getParent().toUri().toString();
        if (this.isParentOf(absoluteSrc, absoluteDst)) {
            throw new IOException("Cannot rename " + absoluteSrc + " under itself : " + absoluteDst);
        }
        if (!parentSrc.equals(parentDst)) {
            throw new IOException("Cannot rename source: " + absoluteSrc + " to " + absoluteDst + " -" + E_SAME_DIRECTORY_ONLY);
        }
        String from = absoluteSrc.getName();
        String to = absoluteDst.getName();
        client.changeWorkingDirectory(parentSrc);
        boolean renamed = client.rename(from, to);
        return renamed;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.getHomeDirectory();
    }

    @Override
    public Path getHomeDirectory() {
        FTPClient client = null;
        try {
            Path homeDir;
            client = this.connect();
            Path path = homeDir = new Path(client.printWorkingDirectory());
            return path;
        }
        catch (IOException ioe) {
            throw new FTPException("Failed to get home directory", ioe);
        }
        finally {
            try {
                this.disconnect(client);
            }
            catch (IOException ioe) {
                throw new FTPException("Failed to disconnect", ioe);
            }
        }
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
    }
}

