/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.tool.Tool;

public class DataFileRepairTool
implements Tool {
    private static final Set<String> OPTIONS = new HashSet<String>();
    private static final String ALL = "all";
    private static final String PRIOR = "prior";
    private static final String AFTER = "after";
    private static final String REPORT = "report";

    @Override
    public String getName() {
        return "repair";
    }

    @Override
    public String getShortDescription() {
        return "Recovers data from a corrupt Avro Data file";
    }

    private void printInfo(PrintStream output) {
        output.println("Insufficient arguments.  Arguments:  [-o option] input_file output_file \n   Where option is one of the following: \n      all (default) recover as many records as possible.\n      prior         recover only records prior to the first instance of corruption \n      after         recover only records after the first instance of corruption.\n      report        print the corruption report only, reporting the\n                    number of valid and corrupted blocks and records\n   input_file is the file to read from.  output_file is the file to\n   create and write recovered data to.  output_file is ignored if\n   using the report option.");
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() < 2) {
            this.printInfo(err);
            return 1;
        }
        int index = 0;
        String input = args.get(index);
        String option = ALL;
        if ("-o".equals(input)) {
            option = args.get(1);
            index += 2;
        }
        if (!OPTIONS.contains(option) || args.size() - index < 1) {
            this.printInfo(err);
            return 1;
        }
        input = args.get(index++);
        if (!REPORT.equals(option) && args.size() - index < 1) {
            this.printInfo(err);
            return 1;
        }
        if (ALL.equals(option)) {
            return this.recoverAll(input, args.get(index), out, err);
        }
        if (PRIOR.equals(option)) {
            return this.recoverPrior(input, args.get(index), out, err);
        }
        if (AFTER.equals(option)) {
            return this.recoverAfter(input, args.get(index), out, err);
        }
        if (REPORT.equals(option)) {
            return this.reportOnly(input, out, err);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int recover(String input, String output, PrintStream out, PrintStream err, boolean recoverPrior, boolean recoverAfter) throws IOException {
        File infile = new File(input);
        if (!infile.canRead()) {
            err.println("cannot read file: " + input);
            return 1;
        }
        out.println("Recovering file: " + input);
        GenericDatumReader reader = new GenericDatumReader();
        try (DataFileReader<Object> fileReader = new DataFileReader<Object>(infile, reader);){
            Schema schema = fileReader.getSchema();
            String codecStr = fileReader.getMetaString("avro.codec");
            CodecFactory codecFactory = CodecFactory.fromString("" + codecStr);
            List<String> metas = fileReader.getMetaKeys();
            if (recoverPrior || recoverAfter) {
                GenericDatumWriter writer = new GenericDatumWriter();
                DataFileWriter<Object> fileWriter = new DataFileWriter<Object>(writer);
                try {
                    int result;
                    File outfile = new File(output);
                    for (String key : metas) {
                        if (key.startsWith("avro.")) continue;
                        byte[] val = fileReader.getMeta(key);
                        fileWriter.setMeta(key, val);
                    }
                    fileWriter.setCodec(codecFactory);
                    int n = result = this.innerRecover(fileReader, fileWriter, out, err, recoverPrior, recoverAfter, schema, outfile);
                    return n;
                }
                catch (Exception e) {
                    e.printStackTrace(err);
                    int n = 1;
                    fileReader.close();
                    return n;
                }
            }
            int n = this.innerRecover(fileReader, null, out, err, recoverPrior, recoverAfter, null, null);
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int innerRecover(DataFileReader<Object> fileReader, DataFileWriter<Object> fileWriter, PrintStream out, PrintStream err, boolean recoverPrior, boolean recoverAfter, Schema schema, File outfile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 30[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int reportOnly(String input, PrintStream out, PrintStream err) throws IOException {
        return this.recover(input, null, out, err, false, false);
    }

    private int recoverAfter(String input, String output, PrintStream out, PrintStream err) throws IOException {
        return this.recover(input, output, out, err, false, true);
    }

    private int recoverPrior(String input, String output, PrintStream out, PrintStream err) throws IOException {
        return this.recover(input, output, out, err, true, false);
    }

    private int recoverAll(String input, String output, PrintStream out, PrintStream err) throws IOException {
        return this.recover(input, output, out, err, true, true);
    }

    static {
        OPTIONS.add(ALL);
        OPTIONS.add(PRIOR);
        OPTIONS.add(AFTER);
        OPTIONS.add(REPORT);
    }
}

