/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class DataFileReadTool
implements Tool {
    @Override
    public String getName() {
        return "tojson";
    }

    @Override
    public String getShortDescription() {
        return "Dumps an Avro data file as JSON, record per line or pretty.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder prettyOption = optionParser.accepts("pretty", "Turns on pretty printing.");
        OptionSet optionSet = optionParser.parse(args.toArray(new String[0]));
        Boolean pretty = optionSet.has(prettyOption);
        List<?> nargs = optionSet.nonOptionArguments();
        if (nargs.size() != 1) {
            this.printHelp(err);
            err.println();
            optionParser.printHelpOn(err);
            return 1;
        }
        BufferedInputStream inStream = Util.fileOrStdin((String)nargs.get(0), stdin);
        GenericDatumReader reader = new GenericDatumReader();
        try (DataFileStream streamReader = new DataFileStream(inStream, reader);){
            Schema schema = streamReader.getSchema();
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            JsonEncoder encoder = EncoderFactory.get().jsonEncoder(schema, out, pretty);
            for (Object datum : streamReader) {
                writer.write(datum, encoder);
            }
            encoder.flush();
            out.println();
            out.flush();
        }
        return 0;
    }

    private void printHelp(PrintStream ps) {
        ps.println("tojson --pretty input-file");
        ps.println();
        ps.println(this.getShortDescription());
        ps.println("A dash ('-') can be given as an input file to use stdin");
    }
}

