/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.compiler.specific;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.SchemaNormalization;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.codehaus.jackson.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificCompiler {
    private static final int JVM_METHOD_ARG_LIMIT = 255;
    protected static final int MAX_FIELD_PARAMETER_UNIT_COUNT = 254;
    private static final SpecificData SPECIFIC = new SpecificData();
    private final Set<Schema> queue = new HashSet<Schema>();
    private Protocol protocol;
    private VelocityEngine velocityEngine;
    private String templateDir;
    private FieldVisibility fieldVisibility = FieldVisibility.PUBLIC_DEPRECATED;
    private boolean createSetters = true;
    private boolean createAllArgsConstructor = true;
    private String outputCharacterEncoding;
    private boolean enableDecimalLogicalType = false;
    private String suffix = ".java";
    private static final Set<String> ACCESSOR_MUTATOR_RESERVED_WORDS;
    private static final Set<String> ERROR_RESERVED_WORDS;
    private static final String FILE_HEADER = "/**\n * Autogenerated by Avro\n *\n * DO NOT EDIT DIRECTLY\n */\n";
    private static String logChuteName;
    private GenericData.StringType stringType = GenericData.StringType.CharSequence;
    private static final Schema NULL_SCHEMA;
    int maxStringChars = 8192;

    public boolean isCreateAllArgsConstructor() {
        return this.createAllArgsConstructor;
    }

    public SpecificCompiler(Protocol protocol) {
        this();
        for (Schema s : protocol.getTypes()) {
            this.enqueue(s);
        }
        this.protocol = protocol;
    }

    public SpecificCompiler(Schema schema) {
        this();
        this.enqueue(schema);
        this.protocol = null;
    }

    SpecificCompiler() {
        this.templateDir = System.getProperty("org.apache.avro.specific.templates", "/org/apache/avro/compiler/specific/templates/java/classic/");
        this.initializeVelocity();
    }

    public void setTemplateDir(String templateDir) {
        this.templateDir = templateDir;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean deprecatedFields() {
        return this.fieldVisibility == FieldVisibility.PUBLIC_DEPRECATED;
    }

    public boolean publicFields() {
        return this.fieldVisibility == FieldVisibility.PUBLIC || this.fieldVisibility == FieldVisibility.PUBLIC_DEPRECATED;
    }

    public boolean privateFields() {
        return this.fieldVisibility == FieldVisibility.PRIVATE;
    }

    public void setFieldVisibility(FieldVisibility fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    public boolean isCreateSetters() {
        return this.createSetters;
    }

    public void setCreateSetters(boolean createSetters) {
        this.createSetters = createSetters;
    }

    public void setEnableDecimalLogicalType(boolean enableDecimalLogicalType) {
        this.enableDecimalLogicalType = enableDecimalLogicalType;
    }

    private void initializeVelocity() {
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.addProperty("resource.loader", "class, file");
        this.velocityEngine.addProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        this.velocityEngine.addProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        this.velocityEngine.addProperty("file.resource.loader.path", "/, .");
        this.velocityEngine.setProperty("runtime.references.strict", true);
        if (null == logChuteName) {
            try {
                new Slf4jLogChute();
                logChuteName = Slf4jLogChute.class.getName();
            }
            catch (Exception e) {
                logChuteName = "org.apache.velocity.runtime.log.NullLogChute";
            }
        }
        this.velocityEngine.setProperty("runtime.log.logsystem.class", logChuteName);
    }

    public static void compileProtocol(File src, File dest) throws IOException {
        SpecificCompiler.compileProtocol(new File[]{src}, dest);
    }

    public static void compileProtocol(File[] srcFiles, File dest) throws IOException {
        for (File src : srcFiles) {
            Protocol protocol = Protocol.parse(src);
            SpecificCompiler compiler = new SpecificCompiler(protocol);
            compiler.compileToDestination(src, dest);
        }
    }

    public static void compileSchema(File src, File dest) throws IOException {
        SpecificCompiler.compileSchema(new File[]{src}, dest);
    }

    public static void compileSchema(File[] srcFiles, File dest) throws IOException {
        Schema.Parser parser = new Schema.Parser();
        for (File src : srcFiles) {
            Schema schema = parser.parse(src);
            SpecificCompiler compiler = new SpecificCompiler(schema);
            compiler.compileToDestination(src, dest);
        }
    }

    private void enqueue(Schema schema) {
        if (this.queue.contains(schema)) {
            return;
        }
        switch (schema.getType()) {
            case RECORD: {
                this.queue.add(schema);
                for (Schema.Field field : schema.getFields()) {
                    this.enqueue(field.schema());
                }
                break;
            }
            case MAP: {
                this.enqueue(schema.getValueType());
                break;
            }
            case ARRAY: {
                this.enqueue(schema.getElementType());
                break;
            }
            case UNION: {
                for (Schema s : schema.getTypes()) {
                    this.enqueue(s);
                }
                break;
            }
            case ENUM: 
            case FIXED: {
                this.queue.add(schema);
                break;
            }
            case STRING: 
            case BYTES: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
    }

    Collection<OutputFile> compile() {
        ArrayList<OutputFile> out = new ArrayList<OutputFile>();
        for (Schema schema : this.queue) {
            out.add(this.compile(schema));
        }
        if (this.protocol != null) {
            out.add(this.compileInterface(this.protocol));
        }
        return out;
    }

    public void compileToDestination(File src, File dst) throws IOException {
        for (Schema schema : this.queue) {
            OutputFile o = this.compile(schema);
            o.writeToDestination(src, dst);
        }
        if (this.protocol != null) {
            this.compileInterface(this.protocol).writeToDestination(src, dst);
        }
    }

    private String renderTemplate(String templateName, VelocityContext context) {
        Template template;
        try {
            template = this.velocityEngine.getTemplate(templateName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StringWriter writer = new StringWriter();
        template.merge(context, writer);
        return writer.toString();
    }

    OutputFile compileInterface(Protocol protocol) {
        protocol = this.addStringType(protocol);
        VelocityContext context = new VelocityContext();
        context.put("protocol", protocol);
        context.put("this", this);
        String out = this.renderTemplate(this.templateDir + "protocol.vm", context);
        OutputFile outputFile = new OutputFile();
        String mangledName = SpecificCompiler.mangle(protocol.getName());
        outputFile.path = this.makePath(mangledName, protocol.getNamespace());
        outputFile.contents = out;
        outputFile.outputCharacterEncoding = this.outputCharacterEncoding;
        return outputFile;
    }

    String makePath(String name, String space) {
        if (space == null || space.isEmpty()) {
            return name + this.suffix;
        }
        return space.replace('.', File.separatorChar) + File.separatorChar + name + this.suffix;
    }

    protected int calcAllArgConstructorParameterUnits(Schema record) {
        if (record.getType() != Schema.Type.RECORD) {
            throw new RuntimeException("This method must only be called for record schemas.");
        }
        return record.getFields().size();
    }

    protected void validateRecordForCompilation(Schema record) {
        boolean bl = this.createAllArgsConstructor = this.calcAllArgConstructorParameterUnits(record) <= 254;
        if (!this.createAllArgsConstructor) {
            new Slf4jLogChute().log(2, "Record '" + record.getFullName() + "' contains more than " + 254 + " parameters which exceeds the JVM spec for the number of permitted constructor arguments. Clients must rely on the builder pattern to create objects instead. For more info see JIRA ticket AVRO-1642.");
        }
    }

    OutputFile compile(Schema schema) {
        schema = this.addStringType(schema);
        String output = "";
        VelocityContext context = new VelocityContext();
        context.put("this", this);
        context.put("schema", schema);
        switch (schema.getType()) {
            case RECORD: {
                this.validateRecordForCompilation(schema);
                output = this.renderTemplate(this.templateDir + "record.vm", context);
                break;
            }
            case ENUM: {
                output = this.renderTemplate(this.templateDir + "enum.vm", context);
                break;
            }
            case FIXED: {
                output = this.renderTemplate(this.templateDir + "fixed.vm", context);
                break;
            }
            case BOOLEAN: 
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
        OutputFile outputFile = new OutputFile();
        String name = SpecificCompiler.mangle(schema.getName());
        outputFile.path = this.makePath(name, schema.getNamespace());
        outputFile.contents = output;
        outputFile.outputCharacterEncoding = this.outputCharacterEncoding;
        return outputFile;
    }

    public void setStringType(GenericData.StringType t) {
        this.stringType = t;
    }

    private Protocol addStringType(Protocol p) {
        if (this.stringType != GenericData.StringType.String) {
            return p;
        }
        Protocol newP = new Protocol(p.getName(), p.getDoc(), p.getNamespace());
        LinkedHashMap<Schema, Schema> types = new LinkedHashMap<Schema, Schema>();
        for (Map.Entry<String, JsonNode> entry : p.getJsonProps().entrySet()) {
            newP.addProp(entry.getKey(), entry.getValue());
        }
        LinkedHashSet<Schema> namedTypes = new LinkedHashSet<Schema>();
        for (Schema s : p.getTypes()) {
            namedTypes.add(this.addStringType(s, types));
        }
        newP.setTypes(namedTypes);
        Map<String, Protocol.Message> map = newP.getMessages();
        for (Protocol.Message m : p.getMessages().values()) {
            map.put(m.getName(), m.isOneWay() ? newP.createMessage(m.getName(), m.getDoc(), m.getJsonProps(), this.addStringType(m.getRequest(), types)) : newP.createMessage(m.getName(), m.getDoc(), m.getJsonProps(), this.addStringType(m.getRequest(), types), this.addStringType(m.getResponse(), types), this.addStringType(m.getErrors(), types)));
        }
        return newP;
    }

    private Schema addStringType(Schema s) {
        if (this.stringType != GenericData.StringType.String) {
            return s;
        }
        return this.addStringType(s, new LinkedHashMap<Schema, Schema>());
    }

    private Schema addStringType(Schema s, Map<Schema, Schema> seen) {
        if (seen.containsKey(s)) {
            return seen.get(s);
        }
        Schema result = s;
        switch (s.getType()) {
            case STRING: {
                result = Schema.create(Schema.Type.STRING);
                GenericData.setStringType(result, this.stringType);
                break;
            }
            case RECORD: {
                result = Schema.createRecord(s.getFullName(), s.getDoc(), null, s.isError());
                for (String string : s.getAliases()) {
                    result.addAlias(string, null);
                }
                seen.put(s, result);
                ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
                for (Schema.Field f : s.getFields()) {
                    Schema fSchema = this.addStringType(f.schema(), seen);
                    Schema.Field newF = new Schema.Field(f.name(), fSchema, f.doc(), f.defaultValue(), f.order());
                    for (Map.Entry<String, JsonNode> p : f.getJsonProps().entrySet()) {
                        newF.addProp(p.getKey(), p.getValue());
                    }
                    for (String a : f.aliases()) {
                        newF.addAlias(a);
                    }
                    newFields.add(newF);
                }
                result.setFields(newFields);
                break;
            }
            case ARRAY: {
                Schema schema = this.addStringType(s.getElementType(), seen);
                result = Schema.createArray(schema);
                break;
            }
            case MAP: {
                Schema v = this.addStringType(s.getValueType(), seen);
                result = Schema.createMap(v);
                GenericData.setStringType(result, this.stringType);
                break;
            }
            case UNION: {
                ArrayList<Schema> types = new ArrayList<Schema>();
                for (Schema branch : s.getTypes()) {
                    types.add(this.addStringType(branch, seen));
                }
                result = Schema.createUnion(types);
            }
        }
        for (Map.Entry<String, JsonNode> entry : s.getJsonProps().entrySet()) {
            result.addProp(entry.getKey(), entry.getValue());
        }
        seen.put(s, result);
        return result;
    }

    private String getStringType(JsonNode overrideClassProperty) {
        if (overrideClassProperty != null) {
            return overrideClassProperty.getTextValue();
        }
        switch (this.stringType) {
            case String: {
                return "java.lang.String";
            }
            case Utf8: {
                return "org.apache.avro.util.Utf8";
            }
            case CharSequence: {
                return "java.lang.CharSequence";
            }
        }
        throw new RuntimeException("Unknown string type: " + (Object)((Object)this.stringType));
    }

    public String javaType(Schema schema) {
        return this.javaType(schema, true);
    }

    private String javaType(Schema schema, boolean checkConvertedLogicalType) {
        String convertedLogicalType;
        if (checkConvertedLogicalType && (convertedLogicalType = this.getConvertedLogicalType(schema)) != null) {
            return convertedLogicalType;
        }
        switch (schema.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return SpecificCompiler.mangle(schema.getFullName());
            }
            case ARRAY: {
                return "java.util.List<" + this.javaType(schema.getElementType()) + ">";
            }
            case MAP: {
                return "java.util.Map<" + this.getStringType(schema.getJsonProp("java-key-class")) + "," + this.javaType(schema.getValueType()) + ">";
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return this.javaType(types.get(types.get(0).equals(NULL_SCHEMA) ? 1 : 0));
                }
                return "java.lang.Object";
            }
            case STRING: {
                return this.getStringType(schema.getJsonProp("java-class"));
            }
            case BYTES: {
                return "java.nio.ByteBuffer";
            }
            case INT: {
                return "java.lang.Integer";
            }
            case LONG: {
                return "java.lang.Long";
            }
            case FLOAT: {
                return "java.lang.Float";
            }
            case DOUBLE: {
                return "java.lang.Double";
            }
            case BOOLEAN: {
                return "java.lang.Boolean";
            }
            case NULL: {
                return "java.lang.Void";
            }
        }
        throw new RuntimeException("Unknown type: " + schema);
    }

    private String getConvertedLogicalType(Schema schema) {
        Conversion<Object> conversion;
        if ((this.enableDecimalLogicalType || !(schema.getLogicalType() instanceof LogicalTypes.Decimal)) && (conversion = SPECIFIC.getConversionFor(schema.getLogicalType())) != null) {
            return conversion.getConvertedType().getName();
        }
        return null;
    }

    public String javaUnbox(Schema schema) {
        String convertedLogicalType = this.getConvertedLogicalType(schema);
        if (convertedLogicalType != null) {
            return convertedLogicalType;
        }
        switch (schema.getType()) {
            case INT: {
                return "int";
            }
            case LONG: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case BOOLEAN: {
                return "boolean";
            }
        }
        return this.javaType(schema, false);
    }

    public boolean hasLogicalTypeField(Schema schema) {
        for (Schema.Field field : schema.getFields()) {
            if (field.schema().getLogicalType() == null) continue;
            return true;
        }
        return false;
    }

    public String conversionInstance(Schema schema) {
        if (schema == null || schema.getLogicalType() == null) {
            return "null";
        }
        if (LogicalTypes.date().equals(schema.getLogicalType())) {
            return "DATE_CONVERSION";
        }
        if (LogicalTypes.timeMillis().equals(schema.getLogicalType())) {
            return "TIME_CONVERSION";
        }
        if (LogicalTypes.timestampMillis().equals(schema.getLogicalType())) {
            return "TIMESTAMP_CONVERSION";
        }
        if (LogicalTypes.Decimal.class.equals(schema.getLogicalType().getClass())) {
            return this.enableDecimalLogicalType ? "DECIMAL_CONVERSION" : "null";
        }
        return "null";
    }

    public String[] javaAnnotations(JsonProperties props) {
        JsonNode value = props.getJsonProp("javaAnnotation");
        if (value == null) {
            return new String[0];
        }
        if (value.isTextual()) {
            return new String[]{value.getTextValue()};
        }
        if (value.isArray()) {
            int i = 0;
            String[] result = new String[value.size()];
            for (JsonNode v : value) {
                result[i++] = v.getTextValue();
            }
            return result;
        }
        return new String[0];
    }

    public String javaSplit(String s) throws IOException {
        StringBuilder b = new StringBuilder("\"");
        for (int i = 0; i < s.length(); i += this.maxStringChars) {
            if (i != 0) {
                b.append("\",\"");
            }
            String chunk = s.substring(i, Math.min(s.length(), i + this.maxStringChars));
            b.append(SpecificCompiler.javaEscape(chunk));
        }
        b.append("\"");
        return b.toString();
    }

    public static String javaEscape(Object o) {
        return o.toString().replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String escapeForJavadoc(String s) {
        return s.replace("*/", "*&#47;");
    }

    public static String nullToEmpty(String x) {
        return x == null ? "" : x;
    }

    public static String mangle(String word) {
        return SpecificCompiler.mangle(word, false);
    }

    public static String mangle(String word, boolean isError) {
        return SpecificCompiler.mangle(word, isError ? ERROR_RESERVED_WORDS : SpecificData.RESERVED_WORDS);
    }

    public static String mangle(String word, Set<String> reservedWords) {
        return SpecificCompiler.mangle(word, reservedWords, false);
    }

    public static String mangle(String word, Set<String> reservedWords, boolean isMethod) {
        if (word.contains(".")) {
            int lastDot = word.lastIndexOf(".");
            String packageName = word.substring(0, lastDot + 1);
            String className = word.substring(lastDot + 1);
            return packageName + SpecificCompiler.mangle(className, reservedWords, isMethod);
        }
        if (reservedWords.contains(word) || isMethod && reservedWords.contains(Character.toLowerCase(word.charAt(0)) + (word.length() > 1 ? word.substring(1) : ""))) {
            return word + "$";
        }
        return word;
    }

    public static long fingerprint64(Schema schema) {
        return SchemaNormalization.parsingFingerprint64(schema);
    }

    public static String generateGetMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "get", "");
    }

    public static String generateSetMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "set", "");
    }

    public static String generateHasMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "has", "");
    }

    public static String generateClearMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "clear", "");
    }

    public static boolean hasBuilder(Schema schema) {
        switch (schema.getType()) {
            case RECORD: {
                return true;
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                if (types.size() == 2 && types.contains(NULL_SCHEMA)) {
                    return SpecificCompiler.hasBuilder(types.get(types.get(0).equals(NULL_SCHEMA) ? 1 : 0));
                }
                return false;
            }
        }
        return false;
    }

    public static String generateGetBuilderMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "get", "Builder");
    }

    public static String generateSetBuilderMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "set", "Builder");
    }

    public static String generateHasBuilderMethod(Schema schema, Schema.Field field) {
        return SpecificCompiler.generateMethodName(schema, field, "has", "Builder");
    }

    private static String generateMethodName(Schema schema, Schema.Field field, String prefix, String postfix) {
        char firstChar = field.name().charAt(0);
        String conflictingFieldName = (Character.isLowerCase(firstChar) ? Character.toUpperCase(firstChar) : Character.toLowerCase(firstChar)) + (field.name().length() > 1 ? field.name().substring(1) : "");
        boolean fieldNameConflict = schema.getField(conflictingFieldName) != null;
        StringBuilder methodBuilder = new StringBuilder(prefix);
        String fieldName = SpecificCompiler.mangle(field.name(), schema.isError() ? ERROR_RESERVED_WORDS : ACCESSOR_MUTATOR_RESERVED_WORDS, true);
        boolean nextCharToUpper = true;
        for (int ii = 0; ii < fieldName.length(); ++ii) {
            if (fieldName.charAt(ii) == '_') {
                nextCharToUpper = true;
                continue;
            }
            if (nextCharToUpper) {
                methodBuilder.append(Character.toUpperCase(fieldName.charAt(ii)));
                nextCharToUpper = false;
                continue;
            }
            methodBuilder.append(fieldName.charAt(ii));
        }
        methodBuilder.append(postfix);
        if (fieldNameConflict) {
            if (methodBuilder.charAt(methodBuilder.length() - 1) != '$') {
                methodBuilder.append('$');
            }
            methodBuilder.append(Character.isLowerCase(firstChar) ? (char)'0' : '1');
        }
        return methodBuilder.toString();
    }

    public static boolean isUnboxedJavaTypeNullable(Schema schema) {
        switch (schema.getType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        SpecificCompiler.compileProtocol(new File(args[0]), new File(args[1]));
    }

    public void setOutputCharacterEncoding(String outputCharacterEncoding) {
        this.outputCharacterEncoding = outputCharacterEncoding;
    }

    static {
        SPECIFIC.addLogicalTypeConversion(new TimeConversions.DateConversion());
        SPECIFIC.addLogicalTypeConversion(new TimeConversions.TimeConversion());
        SPECIFIC.addLogicalTypeConversion(new TimeConversions.TimestampConversion());
        SPECIFIC.addLogicalTypeConversion(new Conversions.DecimalConversion());
        ACCESSOR_MUTATOR_RESERVED_WORDS = new HashSet<String>(Arrays.asList("class", "schema", "classSchema"));
        ACCESSOR_MUTATOR_RESERVED_WORDS.addAll(SpecificData.RESERVED_WORDS);
        ERROR_RESERVED_WORDS = new HashSet<String>(Arrays.asList("message", "cause"));
        ERROR_RESERVED_WORDS.addAll(ACCESSOR_MUTATOR_RESERVED_WORDS);
        logChuteName = null;
        NULL_SCHEMA = Schema.create(Schema.Type.NULL);
    }

    public static final class Slf4jLogChute
    implements LogChute {
        private Logger logger = LoggerFactory.getLogger("AvroVelocityLogChute");

        @Override
        public void init(RuntimeServices rs) throws Exception {
        }

        @Override
        public void log(int level, String message) {
            switch (level) {
                case 0: {
                    this.logger.debug(message);
                    break;
                }
                case -1: {
                    this.logger.trace(message);
                    break;
                }
                case 2: {
                    this.logger.warn(message);
                    break;
                }
                case 3: {
                    this.logger.error(message);
                    break;
                }
                default: {
                    this.logger.info(message);
                }
            }
        }

        @Override
        public void log(int level, String message, Throwable t) {
            switch (level) {
                case 0: {
                    this.logger.debug(message, t);
                    break;
                }
                case -1: {
                    this.logger.trace(message, t);
                    break;
                }
                case 2: {
                    this.logger.warn(message, t);
                    break;
                }
                case 3: {
                    this.logger.error(message, t);
                    break;
                }
                default: {
                    this.logger.info(message, t);
                }
            }
        }

        @Override
        public boolean isLevelEnabled(int level) {
            switch (level) {
                case 0: {
                    return this.logger.isDebugEnabled();
                }
                case -1: {
                    return this.logger.isTraceEnabled();
                }
                case 2: {
                    return this.logger.isWarnEnabled();
                }
                case 3: {
                    return this.logger.isErrorEnabled();
                }
            }
            return this.logger.isInfoEnabled();
        }
    }

    static class OutputFile {
        String path;
        String contents;
        String outputCharacterEncoding;

        OutputFile() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        File writeToDestination(File src, File destDir) throws IOException {
            File f = new File(destDir, this.path);
            if (src != null && f.exists() && f.lastModified() >= src.lastModified()) {
                return f;
            }
            f.getParentFile().mkdirs();
            Writer fw = null;
            FileOutputStream fos = null;
            try {
                if (this.outputCharacterEncoding != null) {
                    fos = new FileOutputStream(f);
                    fw = new OutputStreamWriter((OutputStream)fos, this.outputCharacterEncoding);
                } else {
                    fw = new FileWriter(f);
                }
                fw.write(SpecificCompiler.FILE_HEADER);
                fw.write(this.contents);
            }
            finally {
                if (fw != null) {
                    fw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            return f;
        }
    }

    public static enum FieldVisibility {
        PUBLIC,
        PUBLIC_DEPRECATED,
        PRIVATE;

    }
}

