/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import redis.embedded.RedisExecProvider;
import redis.embedded.RedisSentinel;
import redis.embedded.exceptions.RedisBuildingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisSentinelBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String CONF_FILENAME = "embedded-redis-sentinel";
    private static final String MASTER_MONITOR_LINE = "sentinel monitor %s 127.0.0.1 %d %d";
    private static final String DOWN_AFTER_LINE = "sentinel down-after-milliseconds %s %d";
    private static final String FAILOVER_LINE = "sentinel failover-timeout %s %d";
    private static final String PARALLEL_SYNCS_LINE = "sentinel parallel-syncs %s %d";
    private static final String PORT_LINE = "port %d";
    private File executable;
    private RedisExecProvider redisExecProvider = RedisExecProvider.defaultProvider();
    private Integer port = 26379;
    private int masterPort = 6379;
    private String masterName = "mymaster";
    private long downAfterMilliseconds = 60000L;
    private long failoverTimeout = 180000L;
    private int parallelSyncs = 1;
    private int quorumSize = 1;
    private String sentinelConf;
    private StringBuilder redisConfigBuilder;

    public RedisSentinelBuilder redisExecProvider(RedisExecProvider redisExecProvider) {
        this.redisExecProvider = redisExecProvider;
        return this;
    }

    public RedisSentinelBuilder port(Integer port) {
        this.port = port;
        return this;
    }

    public RedisSentinelBuilder masterPort(Integer masterPort) {
        this.masterPort = masterPort;
        return this;
    }

    public RedisSentinelBuilder masterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public RedisSentinelBuilder quorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
        return this;
    }

    public RedisSentinelBuilder downAfterMilliseconds(Long downAfterMilliseconds) {
        this.downAfterMilliseconds = downAfterMilliseconds;
        return this;
    }

    public RedisSentinelBuilder failoverTimeout(Long failoverTimeout) {
        this.failoverTimeout = failoverTimeout;
        return this;
    }

    public RedisSentinelBuilder parallelSyncs(int parallelSyncs) {
        this.parallelSyncs = parallelSyncs;
        return this;
    }

    public RedisSentinelBuilder configFile(String redisConf) {
        if (this.redisConfigBuilder != null) {
            throw new RedisBuildingException("Redis configuration is already partially build using setting(String) method!");
        }
        this.sentinelConf = redisConf;
        return this;
    }

    public RedisSentinelBuilder setting(String configLine) {
        if (this.sentinelConf != null) {
            throw new RedisBuildingException("Redis configuration is already set using redis conf file!");
        }
        if (this.redisConfigBuilder == null) {
            this.redisConfigBuilder = new StringBuilder();
        }
        this.redisConfigBuilder.append(configLine);
        this.redisConfigBuilder.append(LINE_SEPARATOR);
        return this;
    }

    public RedisSentinel build() {
        this.tryResolveConfAndExec();
        List<String> args = this.buildCommandArgs();
        return new RedisSentinel(args, this.port);
    }

    private void tryResolveConfAndExec() {
        try {
            if (this.sentinelConf == null) {
                this.resolveSentinelConf();
            }
            this.executable = this.redisExecProvider.get();
        }
        catch (Exception e) {
            throw new RedisBuildingException("Could not build sentinel instance", e);
        }
    }

    public void reset() {
        this.redisConfigBuilder = null;
        this.sentinelConf = null;
    }

    public void addDefaultReplicationGroup() {
        this.setting(String.format(MASTER_MONITOR_LINE, this.masterName, this.masterPort, this.quorumSize));
        this.setting(String.format(DOWN_AFTER_LINE, this.masterName, this.downAfterMilliseconds));
        this.setting(String.format(FAILOVER_LINE, this.masterName, this.failoverTimeout));
        this.setting(String.format(PARALLEL_SYNCS_LINE, this.masterName, this.parallelSyncs));
    }

    private void resolveSentinelConf() throws IOException {
        if (this.redisConfigBuilder == null) {
            this.addDefaultReplicationGroup();
        }
        this.setting(String.format(PORT_LINE, this.port));
        String configString = this.redisConfigBuilder.toString();
        File redisConfigFile = File.createTempFile(this.resolveConfigName(), ".conf");
        redisConfigFile.deleteOnExit();
        Files.write((CharSequence)configString, (File)redisConfigFile, (Charset)Charset.forName("UTF-8"));
        this.sentinelConf = redisConfigFile.getAbsolutePath();
    }

    private String resolveConfigName() {
        return "embedded-redis-sentinel_" + this.port;
    }

    private List<String> buildCommandArgs() {
        Preconditions.checkNotNull((Object)this.sentinelConf);
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.executable.getAbsolutePath());
        args.add(this.sentinelConf);
        args.add("--sentinel");
        if (this.port != null) {
            args.add("--port");
            args.add(Integer.toString(this.port));
        }
        return args;
    }
}

