/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit;

import io.specto.hoverfly.junit.Hoverfly;
import io.specto.hoverfly.junit.HoverflyConfig;
import io.specto.hoverfly.junit.HoverflyMode;
import io.specto.hoverfly.junit.HoverflyRuleUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoverflyRule
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoverflyRule.class);
    private final Hoverfly hoverfly;
    private final URI simulation;
    private final HoverflyMode hoverflyMode;

    private HoverflyRule(URI simulation, HoverflyMode hoverflyMode, HoverflyConfig hoverflyConfig) {
        this.hoverflyMode = hoverflyMode;
        this.hoverfly = new Hoverfly(hoverflyConfig, hoverflyMode);
        this.simulation = simulation;
    }

    public static HoverflyRule inCaptureMode(String recordedFilename) {
        return HoverflyRule.inCaptureMode(recordedFilename, HoverflyConfig.configs());
    }

    public static HoverflyRule inCaptureMode(String recordedFilename, HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(HoverflyRuleUtils.fileRelativeToTestResources(recordedFilename), HoverflyMode.CAPTURE, hoverflyConfig);
    }

    public static HoverflyRule inSimulationMode(String resourceNameOnClasspath) {
        return HoverflyRule.inSimulationMode(resourceNameOnClasspath, HoverflyConfig.configs());
    }

    public static HoverflyRule inSimulationMode(String resourceNameOnClasspath, HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(HoverflyRuleUtils.findResourceOnClasspath(resourceNameOnClasspath), HoverflyMode.SIMULATE, hoverflyConfig);
    }

    public static HoverflyRule inSimulationMode(URL webResourceUrl) {
        return HoverflyRule.inSimulationMode(webResourceUrl, HoverflyConfig.configs());
    }

    public static HoverflyRule inSimulationMode(URL webResourceUrl, HoverflyConfig hoverflyConfig) {
        try {
            return new HoverflyRule(webResourceUrl.toURI(), HoverflyMode.SIMULATE, hoverflyConfig);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void before() throws Throwable {
        this.hoverfly.start();
        if (this.hoverflyMode == HoverflyMode.SIMULATE) {
            this.hoverfly.importSimulation(this.simulation);
        }
    }

    protected void after() {
        try {
            if (this.hoverflyMode == HoverflyMode.CAPTURE) {
                this.hoverfly.exportSimulation(this.simulation);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error exporting", (Throwable)e);
        }
        finally {
            this.hoverfly.stop();
        }
    }

    public int getProxyPort() {
        return this.hoverfly.getProxyPort();
    }
}

