/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.SystemUtils;

class HoverflyRuleUtils {
    private static final String OSX = "OSX";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String ARCH_AMD64 = "amd64";
    private static final String ARCH_386 = "386";

    HoverflyRuleUtils() {
    }

    static URI findResourceOnClasspath(String resourceName) throws URISyntaxException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found with name: " + resourceName);
        }
        return resource.toURI();
    }

    static URI createFileRelativeToClasspath(String resourceName) throws IOException {
        File file = Paths.get(new File("").getAbsolutePath(), resourceName).toFile();
        file.mkdirs();
        if (!file.exists()) {
            file.delete();
        }
        file.createNewFile();
        return file.toURI();
    }

    static String getOs() {
        if (SystemUtils.IS_OS_MAC) {
            return OSX;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return WINDOWS;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return LINUX;
        }
        throw new UnsupportedOperationException(SystemUtils.OS_NAME + " is not currently supported");
    }

    static String getArchitectureType() {
        return SystemUtils.OS_ARCH.contains("64") ? ARCH_AMD64 : ARCH_386;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int findUnusedPort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find available port", e);
        }
    }

    static void setHoverflyTrustStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, KeyManagementException, URISyntaxException {
        InputStream trustStream = HoverflyRuleUtils.findResourceOnClasspath("hoverfly.jks").toURL().openStream();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(trustStream, "hoverfly".toCharArray());
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(trustStore);
        TrustManager[] trustManagers = trustFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManagers, null);
        SSLContext.setDefault(sslContext);
    }
}

