/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit;

import io.specto.hoverfly.junit.CaptureBuilder;
import io.specto.hoverfly.junit.HoverflyMode;
import io.specto.hoverfly.junit.HoverflyRuleUtils;
import io.specto.hoverfly.junit.SimulateBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class HoverflyRule
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoverflyRule.class);
    private static final String BINARY_VERSION = "0.8.2";
    private static final String BINARY_PATH = "hoverfly_v%s_%s_%s";
    private static final int BOOT_TIMEOUT_SECONDS = 10;
    private static final String HEALTH_CHECK_URL = "http://localhost:%s/api/stats";
    private static final String RECORDS_URL = "http://localhost:%s/api/records";
    private final int proxyPort;
    private final int adminPort;
    private final HoverflyMode hoverflyMode;
    private final boolean proxyLocalHost;
    private String serviceDataURI;
    private StartedProcess startedProcess;
    private Path binaryPath;

    HoverflyRule(String dateResourcePath, int proxyPort, int adminPort, HoverflyMode hoverflyMode, boolean proxyLocalHost) throws URISyntaxException, IOException {
        this(proxyPort, adminPort, hoverflyMode, proxyLocalHost);
        URI pathToData = hoverflyMode == HoverflyMode.SIMULATE ? HoverflyRuleUtils.findResourceOnClasspath(dateResourcePath) : HoverflyRuleUtils.createFileRelativeToClasspath(dateResourcePath);
        this.serviceDataURI = Paths.get(pathToData).toString();
    }

    HoverflyRule(URL dataResourcePath, int proxyPort, int adminPort, HoverflyMode hoverflyMode, boolean proxyLocalHost) {
        this(proxyPort, adminPort, hoverflyMode, proxyLocalHost);
        this.serviceDataURI = dataResourcePath.toString();
    }

    HoverflyRule(int proxyPort, int adminPort, HoverflyMode hoverflyMode, boolean proxyLocalHost) {
        this.proxyPort = proxyPort == 0 ? HoverflyRuleUtils.findUnusedPort() : proxyPort;
        this.adminPort = adminPort == 0 ? HoverflyRuleUtils.findUnusedPort() : adminPort;
        this.hoverflyMode = hoverflyMode;
        this.proxyLocalHost = proxyLocalHost;
        LOGGER.info("Setting proxy host to localhost");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("https.proxyHost", "localhost");
        if (this.proxyLocalHost) {
            System.setProperty("http.nonProxyHosts", "");
        } else {
            System.setProperty("http.nonProxyHosts", "local|*.local|169.254/16|*.169.254/16");
        }
        LOGGER.info("Setting proxy proxyPort to " + this.proxyPort);
        System.setProperty("http.proxyPort", String.valueOf(this.proxyPort));
        System.setProperty("https.proxyPort", String.valueOf(this.proxyPort));
        try {
            HoverflyRuleUtils.setHoverflyTrustStore();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set hoverfly trust store", e);
        }
        LOGGER.info("Setting admin port to " + this.adminPort + "\n");
    }

    public static SimulateBuilder buildFromClassPathResource(String serviceDataClasspath) {
        return new SimulateBuilder(serviceDataClasspath);
    }

    public static SimulateBuilder buildFromUrl(String serviceDataUrl) {
        try {
            return new SimulateBuilder(new URL(serviceDataUrl));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to build URL", e);
        }
    }

    public static CaptureBuilder inCaptureMode(String outputDirectory) {
        return new CaptureBuilder(outputDirectory);
    }

    protected void before() throws Throwable {
        if (this.hoverflyMode == HoverflyMode.CAPTURE) {
            Path path = Paths.get(this.serviceDataURI, new String[0]);
            Files.deleteIfExists(path);
        }
        String binaryName = String.format(BINARY_PATH, BINARY_VERSION, HoverflyRuleUtils.getOs(), HoverflyRuleUtils.getArchitectureType()) + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        LOGGER.info("Selecting the following binary based on the current operating system: " + binaryName);
        this.binaryPath = this.extractBinary(binaryName);
        LOGGER.info("Executing binary at " + this.binaryPath);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.binaryPath.toString());
        commands.add("-db");
        commands.add("memory");
        commands.add("-pp");
        commands.add(String.valueOf(this.proxyPort));
        commands.add("-ap");
        commands.add(String.valueOf(this.adminPort));
        if (this.hoverflyMode == HoverflyMode.CAPTURE) {
            commands.add("-capture");
        } else {
            commands.add("-import");
            commands.add(this.serviceDataURI);
        }
        this.startedProcess = new ProcessExecutor().command(commands).redirectOutput((OutputStream)Slf4jStream.of((Logger)LOGGER).asInfo()).directory(this.binaryPath.getParent().toFile()).start();
        this.waitForHoverflyToStart();
    }

    private void waitForHoverflyToStart() {
        Instant now = Instant.now();
        Stream.generate(this::hoverflyHasStarted).peek(b -> {
            if (Duration.between(now, Instant.now()).getSeconds() > 10L) {
                throw new IllegalStateException("Hoverfly has not become healthy within 10 seconds");
            }
        }).anyMatch(b -> b.equals(true));
    }

    private boolean hoverflyHasStarted() {
        boolean healthy = false;
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(String.format(HEALTH_CHECK_URL, this.adminPort)).openConnection();
            con.setRequestMethod("GET");
            LOGGER.debug("Hoverfly health check status code is: " + String.valueOf(con.getResponseCode()));
            boolean bl = healthy = con.getResponseCode() == 200;
            if (!healthy) {
                Thread.sleep(1000L);
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug("Exception curling health check", (Throwable)e);
        }
        return healthy;
    }

    private Path extractBinary(String binaryName) throws IOException, URISyntaxException {
        URI sourceHoverflyUrl = HoverflyRuleUtils.findResourceOnClasspath(binaryName);
        Path temporaryHoverflyPath = Files.createTempFile(binaryName, "", new FileAttribute[0]);
        LOGGER.info("Storing binary in temporary directory " + temporaryHoverflyPath);
        File temporaryHoverflyFile = temporaryHoverflyPath.toFile();
        FileUtils.copyURLToFile((URL)sourceHoverflyUrl.toURL(), (File)temporaryHoverflyFile);
        if (SystemUtils.IS_OS_WINDOWS) {
            temporaryHoverflyFile.setExecutable(true);
            temporaryHoverflyFile.setReadable(true);
            temporaryHoverflyFile.setWritable(true);
        } else {
            Files.setPosixFilePermissions(temporaryHoverflyPath, new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ)));
        }
        return temporaryHoverflyPath;
    }

    protected void after() {
        if (this.hoverflyMode == HoverflyMode.CAPTURE) {
            LOGGER.info("Storing captured data");
            try {
                HttpURLConnection con = (HttpURLConnection)new URL(String.format(RECORDS_URL, this.adminPort)).openConnection();
                con.setRequestMethod("GET");
                Path path = Paths.get(this.serviceDataURI, new String[0]);
                Files.copy(con.getInputStream(), path, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to persist captured data", e);
            }
        }
        LOGGER.info("Destroying hoverfly process");
        this.startedProcess.getProcess().destroy();
        File binary = this.binaryPath.toFile();
        if (binary.exists()) {
            binary.delete();
        }
    }

    public Path getBinaryPath() {
        return this.binaryPath;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }
}

