/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.config.HoverflyConfigValidator;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;

public class RemoteHoverflyConfig
extends HoverflyConfig {
    private String host;
    private String scheme;
    private String authToken;
    private String adminCertificate;

    public RemoteHoverflyConfig host(String host) {
        this.host = host;
        return this;
    }

    public RemoteHoverflyConfig withAuthHeader() {
        this.authToken = System.getenv("HOVERFLY_AUTH_TOKEN");
        return this;
    }

    public RemoteHoverflyConfig withAuthHeader(String authToken) {
        this.authToken = authToken;
        return this;
    }

    public RemoteHoverflyConfig withHttpsAdminEndpoint() {
        this.scheme = "https";
        this.adminPort = 443;
        return this;
    }

    @Override
    public HoverflyConfiguration build() {
        if (this.adminPort == 0) {
            this.adminPort = 8888;
        }
        if (this.proxyPort == 0) {
            this.proxyPort = 8500;
        }
        HoverflyConfiguration configs = new HoverflyConfiguration(this.scheme, this.host, this.proxyPort, this.adminPort, this.proxyLocalHost, this.destination, this.proxyCaCert, this.authToken, this.adminCertificate, this.captureHeaders, this.upstreamProxy);
        HoverflyConfigValidator validator = new HoverflyConfigValidator();
        return validator.validate(configs);
    }
}

