/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.config.HoverflyConfigValidator;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.config.LocalMiddleware;

public class LocalHoverflyConfig
extends HoverflyConfig {
    private String sslCertificatePath;
    private String sslKeyPath;
    private boolean webServer;
    private boolean tlsVerificationDisabled;
    private boolean plainHttpTunneling;
    private LocalMiddleware localMiddleware;

    public LocalHoverflyConfig sslCertificatePath(String sslCertificatePath) {
        this.sslCertificatePath = sslCertificatePath;
        return this;
    }

    public LocalHoverflyConfig sslKeyPath(String sslKeyPath) {
        this.sslKeyPath = sslKeyPath;
        return this;
    }

    public HoverflyConfig localMiddleware(String binary, String path) {
        this.localMiddleware = new LocalMiddleware(binary, path);
        return this;
    }

    public LocalHoverflyConfig asWebServer() {
        this.webServer = true;
        return this;
    }

    public LocalHoverflyConfig disableTlsVerification() {
        this.tlsVerificationDisabled = true;
        return this;
    }

    public HoverflyConfig plainHttpTunneling() {
        this.plainHttpTunneling = true;
        return this;
    }

    @Override
    public HoverflyConfiguration build() {
        HoverflyConfiguration configs = new HoverflyConfiguration(this.proxyPort, this.adminPort, this.proxyLocalHost, this.destination, this.proxyCaCert, this.sslCertificatePath, this.sslKeyPath, this.captureHeaders, this.upstreamProxy);
        configs.setWebServer(this.webServer);
        configs.setTlsVerificationDisabled(this.tlsVerificationDisabled);
        configs.setPlainHttpTunneling(this.plainHttpTunneling);
        configs.setLocalMiddleware(this.localMiddleware);
        HoverflyConfigValidator validator = new HoverflyConfigValidator();
        return validator.validate(configs);
    }
}

