/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.config.LocalMiddleware;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class HoverflyConfiguration {
    private String scheme = "http";
    private String host = "localhost";
    private int proxyPort;
    private int adminPort;
    private boolean proxyLocalHost;
    private String destination;
    private String sslCertificatePath;
    private String sslKeyPath;
    private String authToken;
    private boolean isRemoteInstance;
    private String adminCertificate;
    private String proxyCaCertificate;
    private LocalMiddleware localMiddleware;
    private List<String> captureHeaders = Collections.emptyList();
    private boolean webServer = false;
    private boolean tlsVerificationDisabled = false;
    private boolean plainHttpTunneling = false;
    private String upstreamProxy;

    HoverflyConfiguration(String scheme, String host, int proxyPort, int adminPort, boolean proxyLocalHost, String destination, String proxyCaCertificate, String authToken, String adminCertificate, List<String> captureHeaders, String upstreamProxy) {
        this(proxyPort, adminPort, proxyLocalHost, destination, proxyCaCertificate, null, null, captureHeaders, upstreamProxy);
        this.setScheme(scheme);
        this.setHost(host);
        this.authToken = authToken;
        this.adminCertificate = adminCertificate;
        this.isRemoteInstance = true;
    }

    HoverflyConfiguration(int proxyPort, int adminPort, boolean proxyLocalHost, String destination, String proxyCaCertificate, String sslCertificatePath, String sslKeyPath, List<String> captureHeaders, String upstreamProxy) {
        this.proxyPort = proxyPort;
        this.adminPort = adminPort;
        this.proxyLocalHost = proxyLocalHost;
        this.destination = destination;
        this.proxyCaCertificate = proxyCaCertificate;
        this.sslCertificatePath = sslCertificatePath;
        this.sslKeyPath = sslKeyPath;
        this.captureHeaders = captureHeaders;
        this.upstreamProxy = upstreamProxy;
    }

    public String getHost() {
        return this.host;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public boolean isProxyLocalHost() {
        return this.proxyLocalHost;
    }

    public String getSslCertificatePath() {
        return this.sslCertificatePath;
    }

    public String getSslKeyPath() {
        return this.sslKeyPath;
    }

    public String getDestination() {
        return this.destination;
    }

    public Optional<String> getAuthToken() {
        return Optional.ofNullable(this.authToken);
    }

    public boolean isRemoteInstance() {
        return this.isRemoteInstance;
    }

    public Optional<String> getProxyCaCertificate() {
        return Optional.ofNullable(this.proxyCaCertificate);
    }

    public String getAdminCertificate() {
        return this.adminCertificate;
    }

    public List<String> getCaptureHeaders() {
        return this.captureHeaders;
    }

    public String getUpstreamProxy() {
        return this.upstreamProxy;
    }

    void setHost(String host) {
        if (host != null) {
            this.host = host;
        }
    }

    void setScheme(String scheme) {
        if (scheme != null) {
            this.scheme = scheme;
        }
    }

    void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public boolean isWebServer() {
        return this.webServer;
    }

    public void setWebServer(boolean webServer) {
        this.webServer = webServer;
    }

    public boolean isTlsVerificationDisabled() {
        return this.tlsVerificationDisabled;
    }

    public void setTlsVerificationDisabled(boolean tlsVerificationDisabled) {
        this.tlsVerificationDisabled = tlsVerificationDisabled;
    }

    public boolean isPlainHttpTunneling() {
        return this.plainHttpTunneling;
    }

    public void setPlainHttpTunneling(boolean plainHttpTunneling) {
        this.plainHttpTunneling = plainHttpTunneling;
    }

    public LocalMiddleware getLocalMiddleware() {
        return this.localMiddleware;
    }

    public void setLocalMiddleware(LocalMiddleware localMiddleware) {
        this.localMiddleware = localMiddleware;
    }

    public boolean isMiddlewareEnabled() {
        return this.localMiddleware != null && this.isNotBlank(this.localMiddleware.getBinary()) && this.isNotBlank(this.localMiddleware.getPath());
    }

    private boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }
}

