/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.specto.hoverfly.junit.api.HoverflyClient;
import io.specto.hoverfly.junit.api.HoverflyClientException;
import io.specto.hoverfly.junit.api.model.ModeArguments;
import io.specto.hoverfly.junit.api.view.HoverflyInfoView;
import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.ProxyConfigurer;
import io.specto.hoverfly.junit.core.SimulationSource;
import io.specto.hoverfly.junit.core.SslConfigurer;
import io.specto.hoverfly.junit.core.SystemConfig;
import io.specto.hoverfly.junit.core.SystemConfigFactory;
import io.specto.hoverfly.junit.core.TempFileManager;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.model.Journal;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.core.model.Simulation;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import io.specto.hoverfly.junit.verification.HoverflyVerifications;
import io.specto.hoverfly.junit.verification.VerificationCriteria;
import io.specto.hoverfly.junit.verification.VerificationData;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;

public class Hoverfly
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hoverfly.class);
    private static final ObjectWriter JSON_PRETTY_PRINTER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final int BOOT_TIMEOUT_SECONDS = 10;
    private static final int RETRY_BACKOFF_INTERVAL_MS = 100;
    private final HoverflyConfiguration hoverflyConfig;
    private final HoverflyMode hoverflyMode;
    private final ProxyConfigurer proxyConfigurer;
    private final SslConfigurer sslConfigurer = new SslConfigurer();
    private final HoverflyClient hoverflyClient;
    private final TempFileManager tempFileManager = new TempFileManager();
    private StartedProcess startedProcess;
    private boolean useDefaultSslCert = true;

    public Hoverfly(HoverflyConfig hoverflyConfigBuilder, HoverflyMode hoverflyMode) {
        this.hoverflyConfig = hoverflyConfigBuilder.build();
        this.proxyConfigurer = new ProxyConfigurer(this.hoverflyConfig);
        this.hoverflyClient = HoverflyClient.custom().scheme(this.hoverflyConfig.getScheme()).host(this.hoverflyConfig.getHost()).port(this.hoverflyConfig.getAdminPort()).withAuthToken().build();
        this.hoverflyMode = hoverflyMode;
    }

    public Hoverfly(HoverflyMode hoverflyMode) {
        this(HoverflyConfig.configs(), hoverflyMode);
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        if (this.startedProcess != null) {
            LOGGER.warn("Local Hoverfly is already running.");
            return;
        }
        if (!this.hoverflyConfig.isRemoteInstance()) {
            this.startHoverflyProcess();
        } else {
            this.resetJournal();
        }
        this.waitForHoverflyToBecomeHealthy();
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getDestination())) {
            this.setDestination(this.hoverflyConfig.getDestination());
        }
        if (this.hoverflyMode == HoverflyMode.CAPTURE) {
            this.hoverflyClient.setMode(this.hoverflyMode, new ModeArguments(this.hoverflyConfig.getCaptureHeaders()));
        } else {
            this.hoverflyClient.setMode(this.hoverflyMode);
        }
        if (this.hoverflyConfig.getProxyCaCertificate().isPresent()) {
            this.sslConfigurer.setDefaultSslContext(this.hoverflyConfig.getProxyCaCertificate().get());
        } else if (this.useDefaultSslCert) {
            this.sslConfigurer.setDefaultSslContext();
        }
        this.proxyConfigurer.setProxySystemProperties();
    }

    private void startHoverflyProcess() {
        HoverflyUtils.checkPortInUse(this.hoverflyConfig.getProxyPort());
        HoverflyUtils.checkPortInUse(this.hoverflyConfig.getAdminPort());
        SystemConfig systemConfig = new SystemConfigFactory().createSystemConfig();
        Path binaryPath = this.tempFileManager.copyHoverflyBinary(systemConfig);
        LOGGER.info("Executing binary at {}", (Object)binaryPath);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binaryPath.toString());
        commands.add("-db");
        commands.add("memory");
        commands.add("-pp");
        commands.add(String.valueOf(this.hoverflyConfig.getProxyPort()));
        commands.add("-ap");
        commands.add(String.valueOf(this.hoverflyConfig.getAdminPort()));
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getSslCertificatePath())) {
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getSslCertificatePath(), "ca.crt");
            commands.add("-cert");
            commands.add("ca.crt");
        }
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getSslKeyPath())) {
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getSslKeyPath(), "ca.key");
            commands.add("-key");
            commands.add("ca.key");
            this.useDefaultSslCert = false;
        }
        if (this.hoverflyConfig.isPlainHttpTunneling()) {
            commands.add("-plain-http-tunneling");
        }
        if (this.hoverflyConfig.isWebServer()) {
            commands.add("-webserver");
        }
        if (this.hoverflyConfig.isTlsVerificationDisabled()) {
            commands.add("-tls-verification");
            commands.add("false");
        }
        try {
            this.startedProcess = new ProcessExecutor().command(commands).redirectOutput((OutputStream)System.out).directory(this.tempFileManager.getTempDirectory().toFile()).start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not start Hoverfly process", e);
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    @Deprecated
    public void importSimulation(SimulationSource simulationSource) {
        this.simulate(simulationSource);
    }

    public void simulate(SimulationSource simulationSource) {
        LOGGER.info("Importing simulation data to Hoverfly");
        Simulation simulation = simulationSource.getSimulation();
        this.hoverflyClient.setSimulation(simulation);
    }

    public void reset() {
        this.hoverflyClient.deleteSimulation();
        this.resetJournal();
    }

    public void resetJournal() {
        try {
            this.hoverflyClient.deleteJournal();
        }
        catch (HoverflyClientException e) {
            LOGGER.warn("Older version of Hoverfly may not have a reset journal API", (Throwable)e);
        }
    }

    public void exportSimulation(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Export path cannot be null.");
        }
        LOGGER.info("Exporting simulation data from Hoverfly");
        try {
            Files.deleteIfExists(path);
            Simulation simulation = this.hoverflyClient.getSimulation();
            this.persistSimulation(path, simulation);
        }
        catch (Exception e) {
            LOGGER.error("Failed to export simulation data", (Throwable)e);
        }
    }

    public Simulation getSimulation() {
        return this.hoverflyClient.getSimulation();
    }

    public HoverflyInfoView getHoverflyInfo() {
        return this.hoverflyClient.getConfigInfo();
    }

    public void setDestination(String destination) {
        this.hoverflyClient.setDestination(destination);
    }

    public void setMode(HoverflyMode mode) {
        this.hoverflyClient.setMode(mode);
    }

    public void resetMode(HoverflyMode mode) {
        this.hoverflyClient.setMode(mode, new ModeArguments(this.hoverflyConfig.getCaptureHeaders()));
    }

    public HoverflyConfiguration getHoverflyConfig() {
        return this.hoverflyConfig;
    }

    public HoverflyMode getMode() {
        return HoverflyMode.valueOf(this.hoverflyClient.getConfigInfo().getMode().toUpperCase());
    }

    public boolean isHealthy() {
        return this.hoverflyClient.getHealth();
    }

    public SslConfigurer getSslConfigurer() {
        return this.sslConfigurer;
    }

    public void verify(RequestMatcherBuilder requestMatcher, VerificationCriteria criteria) {
        this.verifyRequest(requestMatcher.build(), criteria);
    }

    public void verify(RequestMatcherBuilder requestMatcher) {
        this.verify(requestMatcher, HoverflyVerifications.times(1));
    }

    public void verifyZeroRequestTo(StubServiceBuilder requestedServiceBuilder) {
        this.verify(requestedServiceBuilder.anyMethod(HoverflyMatchers.any()), HoverflyVerifications.never());
    }

    public void verifyAll() {
        Simulation simulation = this.hoverflyClient.getSimulation();
        simulation.getHoverflyData().getPairs().stream().map(RequestResponsePair::getRequest).forEach(request -> this.verifyRequest((Request)request, HoverflyVerifications.atLeastOnce()));
    }

    private void verifyRequest(Request request, VerificationCriteria criteria) {
        Journal journal = this.hoverflyClient.searchJournal(request);
        criteria.verify(request, new VerificationData(journal));
    }

    private void persistSimulation(Path path, Simulation simulation) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        JSON_PRETTY_PRINTER.writeValue(path.toFile(), (Object)simulation);
    }

    private void waitForHoverflyToBecomeHealthy() {
        Instant now = Instant.now();
        while (Duration.between(now, Instant.now()).getSeconds() < 10L) {
            if (this.hoverflyClient.getHealth()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Hoverfly has not become healthy in 10 seconds");
    }

    private void cleanUp() {
        LOGGER.info("Destroying hoverfly process");
        if (this.startedProcess != null) {
            Process process = this.startedProcess.getProcess();
            process.destroy();
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Integer> future = executorService.submit(process::waitFor);
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.warn("Timeout when waiting for hoverfly process to terminate.");
            }
            executorService.shutdownNow();
        }
        this.proxyConfigurer.restoreProxySystemProperties();
        this.sslConfigurer.reset();
        this.tempFileManager.purge();
    }
}

