/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;

public class ResponseCreators {
    private static final int CREATED = 201;
    private static final int OK = 200;
    private static final int NO_CONTENT = 204;
    private static final int BAD_REQUEST = 400;
    private static final int SERVER_ERROR = 500;
    private static final int FORBIDDEN = 403;
    private static final int UNAUTHORISED = 401;

    private ResponseCreators() {
    }

    public static ResponseBuilder created(String locationHeaderValue) {
        return ResponseBuilder.response().status(201).header("Location", locationHeaderValue);
    }

    public static ResponseBuilder created() {
        return ResponseBuilder.response().status(201);
    }

    public static ResponseBuilder success(String body, String contentType) {
        return ResponseBuilder.response().status(200).body(body).header("Content-Type", contentType);
    }

    public static ResponseBuilder success() {
        return ResponseBuilder.response().status(200);
    }

    public static ResponseBuilder noContent() {
        return ResponseBuilder.response().status(204);
    }

    public static ResponseBuilder badRequest() {
        return ResponseBuilder.response().status(400);
    }

    public static ResponseBuilder serverError() {
        return ResponseBuilder.response().status(500);
    }

    public static ResponseBuilder forbidden() {
        return ResponseBuilder.response().status(403);
    }

    public static ResponseBuilder unauthorised() {
        return ResponseBuilder.response().status(401);
    }

    public static ResponseBuilder success(HttpBodyConverter httpBodyConverter) {
        return ResponseBuilder.response().status(200).body(httpBodyConverter);
    }
}

