/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.HoverflyUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

class HoverflyConfigValidator {
    HoverflyConfigValidator() {
    }

    HoverflyConfiguration validate(HoverflyConfiguration hoverflyConfig) {
        if (hoverflyConfig == null) {
            throw new IllegalArgumentException("HoverflyConfig cannot be null.");
        }
        if (hoverflyConfig.isRemoteInstance()) {
            if (hoverflyConfig.getHost() != null && hoverflyConfig.getHost().startsWith("http")) {
                try {
                    URI uri = new URI(hoverflyConfig.getHost());
                    hoverflyConfig.setHost(uri.getHost());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Remote hoverfly hostname is not valid: " + hoverflyConfig.getHost());
                }
            }
        } else {
            boolean isKeyBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslKeyPath());
            boolean isCertBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslCertificatePath());
            if (isKeyBlank && !isCertBlank || !isKeyBlank && isCertBlank) {
                throw new IllegalArgumentException("Both SSL key and certificate files are required to override the default Hoverfly SSL.");
            }
            if (hoverflyConfig.getProxyPort() == 0) {
                hoverflyConfig.setProxyPort(HoverflyConfigValidator.findUnusedPort());
            }
            if (hoverflyConfig.getAdminPort() == 0) {
                hoverflyConfig.setAdminPort(HoverflyConfigValidator.findUnusedPort());
            }
        }
        if (hoverflyConfig.getProxyCaCertificate().isPresent()) {
            HoverflyUtils.findResourceOnClasspath(hoverflyConfig.getProxyCaCertificate().get());
        }
        return hoverflyConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findUnusedPort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find available port", e);
        }
    }
}

