/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FieldMatcher {
    private final String exactMatch;
    private final String globMatch;
    private final String jsonMatch;
    private final String regexMatch;
    private final String xpathMatch;

    @JsonCreator
    public FieldMatcher(@JsonProperty(value="exactMatch") String exactMatch, @JsonProperty(value="globMatch") String globMatch, @JsonProperty(value="jsonMatch") String jsonMatch, @JsonProperty(value="regexMatch") String regexMatch, @JsonProperty(value="xpathMatch") String xpathMatch) {
        this.exactMatch = exactMatch;
        this.globMatch = globMatch;
        this.jsonMatch = jsonMatch;
        this.regexMatch = regexMatch;
        this.xpathMatch = xpathMatch;
    }

    public String getExactMatch() {
        return this.exactMatch;
    }

    public String getGlobMatch() {
        return this.globMatch;
    }

    public String getJsonMatch() {
        return this.jsonMatch;
    }

    public String getRegexMatch() {
        return this.regexMatch;
    }

    public String getXpathMatch() {
        return this.xpathMatch;
    }

    public static FieldMatcher fromString(String value) {
        Builder builder = new Builder();
        if (value.contains("*")) {
            builder.globMatch(value);
        } else {
            builder.exactMatch(value);
        }
        return builder.build();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static class Builder {
        private String exactMatch = null;
        private String globMatch = null;
        private String jsonMatch = null;
        private String regexMatch = null;
        private String xpathMatch = null;

        Builder() {
        }

        Builder exactMatch(String exactMatch) {
            this.exactMatch = exactMatch;
            return this;
        }

        Builder globMatch(String globMatch) {
            this.globMatch = globMatch;
            return this;
        }

        Builder jsonMatch(String jsonMatch) {
            this.jsonMatch = jsonMatch;
            return this;
        }

        Builder regexMatch(String regexMatch) {
            this.regexMatch = regexMatch;
            return this;
        }

        Builder xpathMatch(String xpathMatch) {
            this.xpathMatch = xpathMatch;
            return this;
        }

        FieldMatcher build() {
            return new FieldMatcher(this.exactMatch, this.globMatch, this.jsonMatch, this.regexMatch, this.xpathMatch);
        }
    }
}

