/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.specto.hoverfly.junit.api.AuthHeaderInterceptor;
import io.specto.hoverfly.junit.api.HoverflyClient;
import io.specto.hoverfly.junit.api.HoverflyClientException;
import io.specto.hoverfly.junit.core.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.model.HoverflyInfo;
import io.specto.hoverfly.junit.core.model.Simulation;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpHoverflyClient
implements HoverflyClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoverflyClient.class);
    private static final String HEALTH_CHECK_PATH = "api/health";
    private static final String SIMULATION_PATH = "api/v2/simulation";
    private static final String INFO_PATH = "api/v2/hoverfly";
    private static final String DESTINATION_PATH = "api/v2/hoverfly/destination";
    private static final String MODE_PATH = "api/v2/hoverfly/mode";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private OkHttpClient client;
    private HttpUrl baseUrl;

    public OkHttpHoverflyClient(HoverflyConfiguration config) {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        config.getAuthToken().ifPresent(token -> clientBuilder.addInterceptor((Interceptor)new AuthHeaderInterceptor((String)token)));
        this.client = clientBuilder.build();
        this.baseUrl = new HttpUrl.Builder().scheme(config.getScheme()).host(config.getHost()).port(config.getAdminPort()).build();
    }

    @Override
    public void setSimulation(Simulation simulation) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH);
            RequestBody body = this.createRequestBody(simulation);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set simulation: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set simulation: " + e.getMessage());
        }
    }

    @Override
    public Simulation getSimulation() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(SIMULATION_PATH);
            Request request = builder.get().build();
            return this.exchange(request, Simulation.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get simulation: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get simulation: " + e.getMessage());
        }
    }

    @Override
    public HoverflyInfo getConfigInfo() {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(INFO_PATH);
            Request request = builder.get().build();
            return this.exchange(request, HoverflyInfo.class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to get config information: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to get config information: " + e.getMessage());
        }
    }

    @Override
    public void setDestination(String destination) {
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(DESTINATION_PATH);
            RequestBody body = this.createRequestBody(new HoverflyInfo(destination, null, null, null));
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set destination: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set destination: " + e.getMessage());
        }
    }

    @Override
    public void setMode(HoverflyMode mode) {
        try {
            RequestBody body = this.createRequestBody(new HoverflyInfo(null, mode.name().toLowerCase(), null, null));
            Request.Builder builder = this.createRequestBuilderWithUrl(MODE_PATH);
            Request request = builder.put(body).build();
            this.exchange(request);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to set mode: {}", (Object)e.getMessage());
            throw new HoverflyClientException("Failed to set mode: " + e.getMessage());
        }
    }

    @Override
    public boolean getHealth() {
        boolean isHealthy = false;
        try {
            Request.Builder builder = this.createRequestBuilderWithUrl(HEALTH_CHECK_PATH);
            Request request = builder.get().build();
            this.exchange(request);
            isHealthy = true;
        }
        catch (Exception e) {
            LOGGER.debug("Hoverfly healthcheck failed: " + e.getMessage());
        }
        return isHealthy;
    }

    private Request.Builder createRequestBuilderWithUrl(String path) {
        return new Request.Builder().url(this.baseUrl.newBuilder().addPathSegments(path).build());
    }

    private RequestBody createRequestBody(Object data) throws JsonProcessingException {
        String content = OBJECT_MAPPER.writeValueAsString(data);
        return RequestBody.create((MediaType)JSON, (String)content);
    }

    private <T> T exchange(Request request, Class<T> clazz) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            this.onFailure(response);
            Object object = OBJECT_MAPPER.readValue(response.body().string(), clazz);
            return (T)object;
        }
    }

    private void exchange(Request request) throws IOException {
        try (Response response = this.client.newCall(request).execute();){
            this.onFailure(response);
        }
    }

    private void onFailure(Response response) throws IOException {
        if (!response.isSuccessful()) {
            String errorResponse = String.format("Unexpected response (code=%d, message=%s)", response.code(), response.body().string());
            throw new IOException(errorResponse);
        }
    }
}

