/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

public class HoverflyConfig {
    private static final String LOCALHOST = "localhost";
    private int proxyPort;
    private int adminPort;
    private boolean proxyLocalHost;
    private boolean remote;
    private String host = "localhost";
    private String sslCertificatePath;
    private String sslKeyPath;
    private String destination;

    private HoverflyConfig() {
    }

    public static HoverflyConfig configs() {
        return new HoverflyConfig();
    }

    public HoverflyConfig proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    public HoverflyConfig adminPort(int adminPort) {
        this.adminPort = adminPort;
        return this;
    }

    public HoverflyConfig proxyLocalHost(boolean proxyLocalHost) {
        this.proxyLocalHost = proxyLocalHost;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public boolean isProxyLocalHost() {
        return this.proxyLocalHost;
    }

    public HoverflyConfig useRemoteInstance() {
        this.remote = true;
        return this;
    }

    public HoverflyConfig useRemoteInstance(String remoteHost) {
        this.remote = true;
        this.host = remoteHost;
        return this;
    }

    public boolean isRemoteInstance() {
        return this.remote;
    }

    public String getHost() {
        return this.host;
    }

    public HoverflyConfig sslCertificatePath(String sslCertificatePath) {
        this.sslCertificatePath = sslCertificatePath;
        return this;
    }

    public HoverflyConfig sslKeyPath(String sslKeyPath) {
        this.sslKeyPath = sslKeyPath;
        return this;
    }

    public String getSslCertificatePath() {
        return this.sslCertificatePath;
    }

    public String getSslKeyPath() {
        return this.sslKeyPath;
    }

    public String getDestination() {
        return this.destination;
    }

    public HoverflyConfig destination(String destination) {
        this.destination = destination;
        return this;
    }
}

