/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.DelaySettings;
import io.specto.hoverfly.junit.core.model.RequestMatcher;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceDelaySettingsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class StubServiceBuilder {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SEPARATOR = "://";
    private static final String PATCH = "PATCH";
    private final String destination;
    private final String scheme;
    private final Set<RequestResponsePair> requestResponsePairs = new HashSet<RequestResponsePair>();
    private final List<DelaySettings> delaySettings = new ArrayList<DelaySettings>();

    StubServiceBuilder(String baseUrl) {
        if (baseUrl.startsWith("https://")) {
            this.scheme = HTTPS;
            this.destination = baseUrl.substring(HTTPS.length() + SEPARATOR.length(), baseUrl.length());
        } else if (baseUrl.startsWith("http://")) {
            this.scheme = HTTP;
            this.destination = baseUrl.substring(HTTP.length() + SEPARATOR.length(), baseUrl.length());
        } else {
            this.scheme = HTTP;
            this.destination = baseUrl;
        }
    }

    public RequestMatcherBuilder get(String path) {
        return RequestMatcherBuilder.requestMatcherBuilder(this, "GET", this.scheme, this.destination, path);
    }

    public RequestMatcherBuilder delete(String path) {
        return RequestMatcherBuilder.requestMatcherBuilder(this, "DELETE", this.scheme, this.destination, path);
    }

    public RequestMatcherBuilder put(String path) {
        return RequestMatcherBuilder.requestMatcherBuilder(this, "PUT", this.scheme, this.destination, path);
    }

    public RequestMatcherBuilder post(String path) {
        return RequestMatcherBuilder.requestMatcherBuilder(this, "POST", this.scheme, this.destination, path);
    }

    public RequestMatcherBuilder patch(String path) {
        return RequestMatcherBuilder.requestMatcherBuilder(this, PATCH, this.scheme, this.destination, path);
    }

    public Set<RequestResponsePair> getRequestResponsePairs() {
        return Collections.unmodifiableSet(this.requestResponsePairs);
    }

    StubServiceBuilder addRequestResponsePair(RequestResponsePair requestResponsePair) {
        this.requestResponsePairs.add(requestResponsePair);
        return this;
    }

    String getDestination() {
        return this.destination;
    }

    public StubServiceDelaySettingsBuilder andDelay(int delay, TimeUnit delayTimeUnit) {
        return new StubServiceDelaySettingsBuilder(delay, delayTimeUnit, this);
    }

    public List<DelaySettings> getDelaySettings() {
        return Collections.unmodifiableList(this.delaySettings);
    }

    void addDelaySetting(DelaySettings delaySettings) {
        if (delaySettings != null) {
            this.delaySettings.add(delaySettings);
        }
    }

    StubServiceBuilder addDelaySetting(RequestMatcher requestMatcher, ResponseBuilder responseBuilder) {
        responseBuilder.addDelay().to(this).forRequest(requestMatcher);
        return this;
    }
}

