/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.rule;

import io.specto.hoverfly.junit.rule.HoverflyRule;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Rule;
import org.junit.runner.Description;

class HoverflyRuleUtils {
    public static final String SRC_TEST_RESOURCES_HOVERFLY = "src/test/resources/hoverfly";

    HoverflyRuleUtils() {
    }

    static Path fileRelativeToTestResourcesHoverfly(String fileName) {
        return Paths.get(SRC_TEST_RESOURCES_HOVERFLY, fileName);
    }

    static void createTestResourcesHoverflyDirectoryIfNoneExisting() {
        Path path = Paths.get(SRC_TEST_RESOURCES_HOVERFLY, new String[0]);
        if (!HoverflyRuleUtils.existsAndIsDirectory(path)) {
            try {
                Files.deleteIfExists(path);
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean existsAndIsDirectory(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    static boolean isAnnotatedWithRule(Description description) {
        Field[] fields;
        boolean isRule = false;
        for (Field field : fields = description.getTestClass().getFields()) {
            if (!field.getType().isAssignableFrom(HoverflyRule.class) || field.getAnnotation(Rule.class) == null) continue;
            isRule = true;
            break;
        }
        return isRule;
    }
}

