/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.SystemConfigFactory;

class SystemConfig {
    private static final String BINARY_PATH_FORMAT = "hoverfly_%s_%s%s";
    private SystemConfigFactory.OsName osName;
    private SystemConfigFactory.ArchType archType;

    SystemConfig(SystemConfigFactory.OsName osName, SystemConfigFactory.ArchType archType) {
        this.osName = osName;
        this.archType = archType;
    }

    SystemConfig() {
    }

    SystemConfigFactory.OsName getOsName() {
        return this.osName;
    }

    void setOsName(SystemConfigFactory.OsName osName) {
        this.osName = osName;
    }

    SystemConfigFactory.ArchType getArchType() {
        return this.archType;
    }

    void setArchType(SystemConfigFactory.ArchType archType) {
        this.archType = archType;
    }

    String getHoverflyBinaryName() {
        String extension = "";
        if (this.osName == SystemConfigFactory.OsName.WINDOWS) {
            extension = ".exe";
        }
        return String.format(BINARY_PATH_FORMAT, this.osName.getName(), this.archType.getName(), extension);
    }
}

