/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

class HoverflyConfigValidator {
    private static final int DEFAULT_PROXY_PORT = 8500;
    private static final int DEFAULT_ADMIN_PORT = 8888;

    HoverflyConfigValidator() {
    }

    HoverflyConfig validate(HoverflyConfig hoverflyConfig) {
        if (hoverflyConfig == null) {
            throw new IllegalArgumentException("HoverflyConfig cannot be null.");
        }
        boolean isKeyBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslKeyPath());
        boolean isCertBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslCertificatePath());
        if (isKeyBlank && !isCertBlank || !isKeyBlank && isCertBlank) {
            throw new IllegalArgumentException("Both SSL key and certificate files are required to override the default Hoverfly SSL.");
        }
        if (hoverflyConfig.isRemoteInstance()) {
            if (!isKeyBlank && !isCertBlank) {
                throw new IllegalArgumentException("Attempt to configure SSL on remote instance is prohibited.");
            }
            if (hoverflyConfig.getHost() != null && hoverflyConfig.getHost().startsWith("http")) {
                try {
                    URI uri = new URI(hoverflyConfig.getHost());
                    hoverflyConfig.useRemoteInstance(uri.getHost());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Remote hoverfly hostname is not valid: " + hoverflyConfig.getHost());
                }
            }
        }
        if (hoverflyConfig.getProxyPort() == 0) {
            hoverflyConfig.proxyPort(hoverflyConfig.isRemoteInstance() ? 8500 : HoverflyConfigValidator.findUnusedPort());
        }
        if (hoverflyConfig.getAdminPort() == 0) {
            hoverflyConfig.adminPort(hoverflyConfig.isRemoteInstance() ? 8888 : HoverflyConfigValidator.findUnusedPort());
        }
        return hoverflyConfig;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findUnusedPort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find available port", e);
        }
    }
}

