/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.HoverflyConfigValidator;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.SimulationSource;
import io.specto.hoverfly.junit.core.SslConfigurer;
import io.specto.hoverfly.junit.core.SystemConfig;
import io.specto.hoverfly.junit.core.SystemConfigFactory;
import io.specto.hoverfly.junit.core.TempFileManager;
import io.specto.hoverfly.junit.core.model.Simulation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class Hoverfly
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hoverfly.class);
    private static final int BOOT_TIMEOUT_SECONDS = 10;
    private static final int RETRY_BACKOFF_INTERVAL_MS = 100;
    private static final String HEALTH_CHECK_PATH = "/api/stats";
    private static final String SIMULATION_PATH = "/api/v2/simulation";
    private final HoverflyConfig hoverflyConfig;
    private final HoverflyMode hoverflyMode;
    private final WebResource hoverflyResource;
    private StartedProcess startedProcess;
    private SslConfigurer sslConfigurer = new SslConfigurer();
    private TempFileManager tempFileManager = new TempFileManager();
    private boolean useDefaultSslCert = true;

    public Hoverfly(HoverflyConfig hoverflyConfig, HoverflyMode hoverflyMode) {
        this.hoverflyConfig = new HoverflyConfigValidator().validate(hoverflyConfig);
        this.hoverflyMode = hoverflyMode;
        this.hoverflyResource = Client.create().resource(UriBuilder.fromUri((String)("http://" + hoverflyConfig.getHost())).port(hoverflyConfig.getAdminPort()).build(new Object[0]));
    }

    public Hoverfly(HoverflyMode hoverflyMode) {
        this(HoverflyConfig.configs(), hoverflyMode);
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        if (!this.hoverflyConfig.isRemoteInstance()) {
            this.startHoverflyProcess();
        }
        this.waitForHoverflyToBecomeHealthy();
        if (this.useDefaultSslCert) {
            this.sslConfigurer.setTrustStore();
        }
        this.setProxySystemProperties();
    }

    private void startHoverflyProcess() {
        HoverflyUtils.checkPortInUse(this.hoverflyConfig.getProxyPort());
        HoverflyUtils.checkPortInUse(this.hoverflyConfig.getAdminPort());
        SystemConfig systemConfig = new SystemConfigFactory().createSystemConfig();
        Path binaryPath = this.tempFileManager.copyHoverflyBinary(systemConfig);
        LOGGER.info("Executing binary at {}", (Object)binaryPath);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(binaryPath.toString());
        commands.add("-db");
        commands.add("memory");
        commands.add("-pp");
        commands.add(String.valueOf(this.hoverflyConfig.getProxyPort()));
        commands.add("-ap");
        commands.add(String.valueOf(this.hoverflyConfig.getAdminPort()));
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getSslCertificatePath())) {
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getSslCertificatePath(), "ca.crt");
            commands.add("-cert");
            commands.add("ca.crt");
        }
        if (StringUtils.isNotBlank((CharSequence)this.hoverflyConfig.getSslKeyPath())) {
            this.tempFileManager.copyClassPathResource(this.hoverflyConfig.getSslKeyPath(), "ca.key");
            commands.add("-key");
            commands.add("ca.key");
            this.useDefaultSslCert = false;
        }
        if (this.hoverflyMode == HoverflyMode.CAPTURE) {
            commands.add("-capture");
        }
        try {
            this.startedProcess = new ProcessExecutor().command(commands).redirectOutput((OutputStream)Slf4jStream.of((Logger)LOGGER).asInfo()).directory(this.tempFileManager.getTempDirectory().toFile()).start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not start Hoverfly process", e);
        }
    }

    @Deprecated
    public void stop() {
        this.cleanUp();
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    public void importSimulation(SimulationSource simulationSource) {
        LOGGER.info("Importing simulation data to Hoverfly");
        simulationSource.getSimulation().ifPresent(s -> this.hoverflyResource.path(SIMULATION_PATH).type(MediaType.APPLICATION_JSON_TYPE).put(s));
    }

    public void exportSimulation(Path path) {
        LOGGER.info("Exporting simulation data from Hoverfly");
        try {
            Files.deleteIfExists(path);
            ObjectWriter objectWriter = new ObjectMapper().writerWithDefaultPrettyPrinter();
            Simulation simulation = (Simulation)this.hoverflyResource.path(SIMULATION_PATH).get(Simulation.class);
            objectWriter.writeValue(path.toFile(), (Object)simulation);
        }
        catch (Exception e) {
            LOGGER.error("Failed to export simulation data", (Throwable)e);
        }
    }

    public Simulation getSimulation() {
        return (Simulation)this.hoverflyResource.path(SIMULATION_PATH).get(Simulation.class);
    }

    public HoverflyConfig getHoverflyConfig() {
        return this.hoverflyConfig;
    }

    private boolean isHealthy() {
        try (ClientResponse response = null;){
            response = (ClientResponse)this.hoverflyResource.path(HEALTH_CHECK_PATH).get(ClientResponse.class);
            LOGGER.debug("Hoverfly health check status code is: {}", (Object)response.getStatus());
            boolean bl = response.getStatus() == ClientResponse.Status.OK.getStatusCode();
            return bl;
        }
        return false;
    }

    private void setProxySystemProperties() {
        LOGGER.info("Setting proxy host to {}", (Object)this.hoverflyConfig.getHost());
        System.setProperty("http.proxyHost", this.hoverflyConfig.getHost());
        System.setProperty("https.proxyHost", this.hoverflyConfig.getHost());
        if (this.hoverflyConfig.isProxyLocalHost()) {
            System.setProperty("http.nonProxyHosts", "");
        } else {
            System.setProperty("http.nonProxyHosts", "local|*.local|169.254/16|*.169.254/16");
        }
        if (this.hoverflyConfig.isRemoteInstance()) {
            String nonProxyHosts = System.getProperty("http.nonProxyHosts");
            nonProxyHosts = StringUtils.isNotBlank((CharSequence)nonProxyHosts) ? String.join((CharSequence)"|", nonProxyHosts, this.hoverflyConfig.getHost()) : this.hoverflyConfig.getHost();
            System.setProperty("http.nonProxyHosts", nonProxyHosts);
        }
        LOGGER.info("Setting proxy proxyPort to {}", (Object)this.hoverflyConfig.getProxyPort());
        System.setProperty("http.proxyPort", String.valueOf(this.hoverflyConfig.getProxyPort()));
        System.setProperty("https.proxyPort", String.valueOf(this.hoverflyConfig.getProxyPort()));
    }

    private void waitForHoverflyToBecomeHealthy() {
        Instant now = Instant.now();
        while (Duration.between(now, Instant.now()).getSeconds() < 10L) {
            if (this.isHealthy()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Hoverfly has not become healthy in 10 seconds");
    }

    private void cleanUp() {
        LOGGER.info("Destroying hoverfly process");
        if (this.startedProcess != null) {
            Process process = this.startedProcess.getProcess();
            process.destroy();
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future<Integer> future = executorService.submit(process::waitFor);
            try {
                future.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                LOGGER.warn("Timeout when waiting for hoverfly process to terminate.");
            }
            executorService.shutdownNow();
        }
        this.tempFileManager.purge();
    }
}

