/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.URL;
import org.apache.commons.lang3.SystemUtils;

class HoverflyUtils {
    private static final String OSX = "OSX";
    private static final String WINDOWS = "windows";
    private static final String LINUX = "linux";
    private static final String ARCH_AMD64 = "amd64";
    private static final String ARCH_386 = "386";
    private static final String BINARY_PATH = "hoverfly_%s_%s";

    HoverflyUtils() {
    }

    static String getBinaryName() {
        return String.format(BINARY_PATH, HoverflyUtils.getOs(), HoverflyUtils.getArchitectureType()) + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
    }

    private static String getOs() {
        if (SystemUtils.IS_OS_MAC) {
            return OSX;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return WINDOWS;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return LINUX;
        }
        throw new UnsupportedOperationException(SystemUtils.OS_NAME + " is not currently supported");
    }

    private static String getArchitectureType() {
        return SystemUtils.OS_ARCH.contains("64") ? ARCH_AMD64 : ARCH_386;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int findUnusedPort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find available port", e);
        }
    }

    static void checkPortInUse(int port) {
        try (ServerSocket serverSocket = new ServerSocket(port);){
            serverSocket.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Port is already in use: " + port);
        }
    }

    static URL findResourceOnClasspath(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(resourceName);
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found with name: " + resourceName);
        }
        return resource;
    }
}

