/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.specto.hoverfly.junit.core.HoverflyUtils;
import io.specto.hoverfly.junit.core.model.GlobalActions;
import io.specto.hoverfly.junit.core.model.HoverflyData;
import io.specto.hoverfly.junit.core.model.HoverflyMetaData;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.core.model.Simulation;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jersey.repackaged.com.google.common.collect.Lists;

@FunctionalInterface
public interface SimulationSource {
    public static final ObjectReader OBJECT_READER = new ObjectMapper().readerFor(Simulation.class);

    public static SimulationSource url(URL url) {
        return () -> {
            try {
                return Optional.of(OBJECT_READER.readValue(url));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read simulation", e);
            }
        };
    }

    public static SimulationSource url(String url) {
        return () -> {
            try {
                return Optional.of(OBJECT_READER.readValue(new URL(url)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot read simulation", e);
            }
        };
    }

    public static SimulationSource classpath(String classpath) {
        return () -> {
            try {
                return Optional.of(OBJECT_READER.readValue(HoverflyUtils.findResourceOnClasspath(classpath)));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load classpath resource: '" + classpath + "'", e);
            }
        };
    }

    public static SimulationSource file(Path path) {
        return () -> {
            try {
                return Optional.of(OBJECT_READER.readValue(path.toFile()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load file resource: '" + path.toString() + "'", e);
            }
        };
    }

    public static SimulationSource dsl(StubServiceBuilder ... stubServiceBuilder) {
        return () -> {
            Set<RequestResponsePair> pairs = Arrays.stream(stubServiceBuilder).map(StubServiceBuilder::getRequestResponsePairs).flatMap(Collection::stream).collect(Collectors.toSet());
            return Optional.of(new Simulation(new HoverflyData(pairs, new GlobalActions(Lists.newArrayList())), new HoverflyMetaData()));
        };
    }

    public static SimulationSource simulation(Simulation simulation) {
        return () -> Optional.of(simulation);
    }

    public static SimulationSource empty() {
        return Optional::empty;
    }

    public Optional<Simulation> getSimulation();
}

