/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public interface HttpBodyConverter {
    public static HttpBodyConverter json(Object body) {
        return HttpBodyConverter.json(body, new ObjectMapper());
    }

    public static HttpBodyConverter json(final Object body, final ObjectMapper objectMapper) {
        return new HttpBodyConverter(){

            @Override
            public String body() {
                try {
                    return objectMapper.writeValueAsString(body);
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("Cannot marshall: " + body, e);
                }
            }

            @Override
            public String contentType() {
                return "application/json";
            }
        };
    }

    public String body();

    public String contentType();
}

