/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.rule;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.specto.hoverfly.junit.core.model.Simulation;
import io.specto.hoverfly.junit.rule.HoverflyRule;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Rule;
import org.junit.runner.Description;

class HoverflyRuleUtils {
    private static final ObjectWriter JSON_PRETTY_PRINTER = new ObjectMapper().writerWithDefaultPrettyPrinter();

    HoverflyRuleUtils() {
    }

    static Path fileRelativeToTestResourcesHoverfly(String fileName) {
        return Paths.get("src/test/resources/hoverfly", new String[0]).resolve(fileName);
    }

    static void createTestResourcesHoverflyDirectoryIfNoneExisting() {
        Path path = Paths.get("src/test/resources/hoverfly", new String[0]);
        if (!HoverflyRuleUtils.existsAndIsDirectory(path)) {
            try {
                Files.deleteIfExists(path);
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean existsAndIsDirectory(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]);
    }

    static boolean isAnnotatedWithRule(Description description) {
        Field[] fields;
        boolean isRule = false;
        for (Field field : fields = description.getTestClass().getFields()) {
            if (!field.getType().isAssignableFrom(HoverflyRule.class) || field.getAnnotation(Rule.class) == null) continue;
            isRule = true;
            break;
        }
        return isRule;
    }

    static void prettyPrintSimulation(Simulation value) {
        try {
            System.out.println("The following simulation is imported to Hoverfly: \n" + JSON_PRETTY_PRINTER.writeValueAsString((Object)value));
        }
        catch (Exception e) {
            throw new HoverflyRule.HoverflyRuleException("Failed to print simulation data: " + e.getMessage());
        }
    }
}

