/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.config;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.config.HoverflyConfigValidator;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.config.LocalMiddleware;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHoverflyConfig
extends HoverflyConfig {
    private String sslCertificatePath;
    private String sslKeyPath;
    private boolean tlsVerificationDisabled;
    private boolean plainHttpTunneling;
    private LocalMiddleware localMiddleware;
    private String upstreamProxy;
    private Optional<Logger> hoverflyLogger = Optional.ofNullable(LoggerFactory.getLogger((String)"hoverfly"));

    public LocalHoverflyConfig sslCertificatePath(String sslCertificatePath) {
        this.sslCertificatePath = sslCertificatePath;
        return this;
    }

    public LocalHoverflyConfig sslKeyPath(String sslKeyPath) {
        this.sslKeyPath = sslKeyPath;
        return this;
    }

    public LocalHoverflyConfig localMiddleware(String binary, String path) {
        this.localMiddleware = new LocalMiddleware(binary, path);
        return this;
    }

    public LocalHoverflyConfig disableTlsVerification() {
        this.tlsVerificationDisabled = true;
        return this;
    }

    public LocalHoverflyConfig plainHttpTunneling() {
        this.plainHttpTunneling = true;
        return this;
    }

    public LocalHoverflyConfig upstreamProxy(InetSocketAddress proxyAddress) {
        this.upstreamProxy = proxyAddress.getHostString() + ":" + proxyAddress.getPort();
        return this;
    }

    public LocalHoverflyConfig upstreamProxy(String upstreamProxy) {
        this.upstreamProxy = upstreamProxy;
        return this;
    }

    public LocalHoverflyConfig logger(String loggerName) {
        this.hoverflyLogger = Optional.ofNullable(loggerName).map(LoggerFactory::getLogger);
        return this;
    }

    public LocalHoverflyConfig logToStdOut() {
        this.hoverflyLogger = Optional.empty();
        return this;
    }

    @Override
    public HoverflyConfiguration build() {
        HoverflyConfiguration configs = new HoverflyConfiguration(this.proxyPort, this.adminPort, this.proxyLocalHost, this.destination, this.proxyCaCert, this.captureHeaders, this.webServer, this.hoverflyLogger, this.statefulCapture);
        configs.setSslCertificatePath(this.sslCertificatePath);
        configs.setSslKeyPath(this.sslKeyPath);
        configs.setTlsVerificationDisabled(this.tlsVerificationDisabled);
        configs.setPlainHttpTunneling(this.plainHttpTunneling);
        configs.setLocalMiddleware(this.localMiddleware);
        configs.setUpstreamProxy(this.upstreamProxy);
        configs.setSimulationPreprocessor(this.simulationPreprocessor);
        HoverflyConfigValidator validator = new HoverflyConfigValidator();
        return validator.validate(configs);
    }
}

