/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core;

import io.specto.hoverfly.junit.core.SystemConfig;
import io.specto.hoverfly.junit.core.SystemInfo;

class SystemConfigFactory {
    private SystemInfo systemInfo = new SystemInfo();

    SystemConfigFactory() {
    }

    SystemConfig createSystemConfig() {
        SystemConfig systemConfig = new SystemConfig();
        if (this.systemInfo.isOsWindows()) {
            systemConfig.setOsName(OsName.WINDOWS);
        } else if (this.systemInfo.isOsLinux()) {
            systemConfig.setOsName(OsName.LINUX);
        } else if (this.systemInfo.isOsMac()) {
            systemConfig.setOsName(OsName.OSX);
        } else {
            throw new UnsupportedOperationException(this.systemInfo.getOsName() + " is not currently supported");
        }
        if (this.systemInfo.is64BitSystem()) {
            systemConfig.setArchType(ArchType.ARCH_AMD64);
        } else {
            systemConfig.setArchType(ArchType.ARCH_386);
        }
        return systemConfig;
    }

    static enum ArchType {
        ARCH_AMD64("amd64"),
        ARCH_386("386");

        private final String name;

        private ArchType(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }

    static enum OsName {
        OSX("OSX"),
        WINDOWS("windows"),
        LINUX("linux");

        private final String name;

        private OsName(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }
    }
}

