/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.Response;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseDelaySettingsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ResponseBuilder {
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private String body = "";
    private int status = 200;
    private boolean templated = true;
    private final Map<String, String> transitionsState = new HashMap<String, String>();
    private final List<String> removesState = new ArrayList<String>();
    private int delay;
    private TimeUnit delayTimeUnit;

    ResponseBuilder() {
    }

    @Deprecated
    public static ResponseBuilder response() {
        return new ResponseBuilder();
    }

    public ResponseBuilder body(String body) {
        this.body = body;
        return this;
    }

    public ResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    public ResponseBuilder header(String key, String value) {
        this.headers.put(key, Collections.singletonList(value));
        return this;
    }

    public ResponseBuilder andSetState(String key, String value) {
        this.transitionsState.put(key, value);
        return this;
    }

    public ResponseBuilder andRemoveState(String stateToRemove) {
        this.removesState.add(stateToRemove);
        return this;
    }

    Response build() {
        return new Response(this.status, this.body, false, this.templated, this.headers, this.transitionsState, this.removesState);
    }

    public ResponseBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = httpBodyConverter.body();
        this.header("Content-Type", httpBodyConverter.contentType());
        return this;
    }

    public ResponseBuilder disableTemplating() {
        this.templated = false;
        return this;
    }

    public ResponseBuilder withDelay(int delay, TimeUnit delayTimeUnit) {
        this.delay = delay;
        this.delayTimeUnit = delayTimeUnit;
        return this;
    }

    ResponseDelaySettingsBuilder addDelay() {
        return new ResponseDelaySettingsBuilder(this.delay, this.delayTimeUnit);
    }
}

