/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.DelaySettings;
import io.specto.hoverfly.junit.core.model.FieldMatcher;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceDelaySettingsBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import io.specto.hoverfly.junit.dsl.matchers.PlainTextFieldMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class StubServiceBuilder {
    private final Set<RequestResponsePair> requestResponsePairs = new HashSet<RequestResponsePair>();
    private final List<DelaySettings> delaySettings = new ArrayList<DelaySettings>();
    private static final String SEPARATOR = "://";
    protected final FieldMatcher destination;
    protected FieldMatcher scheme;

    public RequestMatcherBuilder get(String path) {
        return this.get(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder get(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.GET, path);
    }

    public RequestMatcherBuilder delete(String path) {
        return this.delete(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder delete(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.DELETE, path);
    }

    public RequestMatcherBuilder put(String path) {
        return this.put(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder put(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.PUT, path);
    }

    public RequestMatcherBuilder post(String path) {
        return this.post(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder post(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.POST, path);
    }

    public RequestMatcherBuilder patch(String path) {
        return this.patch(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder patch(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.PATCH, path);
    }

    public RequestMatcherBuilder options(String path) {
        return this.options(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder options(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.OPTIONS, path);
    }

    public RequestMatcherBuilder head(String path) {
        return this.head(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder head(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.HEAD, path);
    }

    public RequestMatcherBuilder connect(String path) {
        return this.connect(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder connect(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.CONNECT, path);
    }

    public RequestMatcherBuilder anyMethod(String path) {
        return this.anyMethod(HoverflyMatchers.equalsTo(path));
    }

    public RequestMatcherBuilder anyMethod(PlainTextFieldMatcher path) {
        return this.createRequestMatcherBuilder(HttpMethod.ANY, path);
    }

    StubServiceBuilder(String baseUrl) {
        String[] elements = baseUrl.split(SEPARATOR);
        if (baseUrl.contains(SEPARATOR)) {
            this.scheme = FieldMatcher.exactlyMatches(elements[0]);
            this.destination = FieldMatcher.exactlyMatches(elements[1]);
        } else {
            this.destination = FieldMatcher.exactlyMatches(elements[0]);
        }
    }

    StubServiceBuilder(PlainTextFieldMatcher matcher) {
        this.destination = matcher.getFieldMatcher();
    }

    public Set<RequestResponsePair> getRequestResponsePairs() {
        return Collections.unmodifiableSet(this.requestResponsePairs);
    }

    StubServiceBuilder addRequestResponsePair(RequestResponsePair requestResponsePair) {
        this.requestResponsePairs.add(requestResponsePair);
        return this;
    }

    String getDestination() {
        return this.destination.getMatchPattern();
    }

    public StubServiceDelaySettingsBuilder andDelay(int delay, TimeUnit delayTimeUnit) {
        return new StubServiceDelaySettingsBuilder(delay, delayTimeUnit, this);
    }

    public List<DelaySettings> getDelaySettings() {
        return Collections.unmodifiableList(this.delaySettings);
    }

    void addDelaySetting(DelaySettings delaySettings) {
        if (delaySettings != null) {
            this.delaySettings.add(delaySettings);
        }
    }

    StubServiceBuilder addDelaySetting(Request request, ResponseBuilder responseBuilder) {
        responseBuilder.addDelay().to(this).forRequest(request);
        return this;
    }

    private RequestMatcherBuilder createRequestMatcherBuilder(HttpMethod httpMethod, PlainTextFieldMatcher path) {
        return new RequestMatcherBuilder(this, httpMethod, this.scheme, this.destination, path);
    }

    static enum HttpMethod {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH,
        OPTIONS,
        CONNECT,
        HEAD,
        ANY;


        FieldMatcher getFieldMatcher() {
            FieldMatcher fieldMatcher = null;
            if (this != ANY) {
                fieldMatcher = FieldMatcher.exactlyMatches(this.name());
            }
            return fieldMatcher;
        }
    }
}

