/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.dsl;

import io.specto.hoverfly.junit.core.model.FieldMatcher;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.RequestResponsePair;
import io.specto.hoverfly.junit.dsl.HttpBodyConverter;
import io.specto.hoverfly.junit.dsl.ResponseBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import io.specto.hoverfly.junit.dsl.matchers.HoverflyMatchers;
import io.specto.hoverfly.junit.dsl.matchers.PlainTextFieldMatcher;
import io.specto.hoverfly.junit.dsl.matchers.RequestFieldMatcher;
import io.specto.hoverfly.junit.dsl.matchers.RequestMatcherType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RequestMatcherBuilder {
    private StubServiceBuilder invoker;
    private final FieldMatcher method;
    private final FieldMatcher scheme;
    private final FieldMatcher destination;
    private final FieldMatcher path;
    private final List<String> exactMatchQueries = new ArrayList<String>();
    private final List<String> globMatchQueries = new ArrayList<String>();
    private final List<String> regexMatchQueries = new ArrayList<String>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, String> requiresState = new HashMap<String, String>();
    private FieldMatcher query = FieldMatcher.blankMatcher();
    private FieldMatcher body = FieldMatcher.blankMatcher();

    RequestMatcherBuilder(StubServiceBuilder invoker, StubServiceBuilder.HttpMethod method, FieldMatcher scheme, FieldMatcher destination, PlainTextFieldMatcher path) {
        this.invoker = invoker;
        this.method = method.getFieldMatcher();
        this.scheme = scheme;
        this.destination = destination;
        this.path = path.getFieldMatcher();
    }

    public RequestMatcherBuilder body(String body) {
        this.body = FieldMatcher.exactlyMatches(body);
        return this;
    }

    public RequestMatcherBuilder body(HttpBodyConverter httpBodyConverter) {
        this.body = FieldMatcher.exactlyMatches(httpBodyConverter.body());
        return this;
    }

    public RequestMatcherBuilder body(RequestFieldMatcher matcher) {
        this.body = matcher.getFieldMatcher();
        return this;
    }

    public RequestMatcherBuilder anyBody() {
        this.body = null;
        return this;
    }

    public RequestMatcherBuilder header(String key, String value) {
        this.headers.put(key, Collections.singletonList(value));
        return this;
    }

    public RequestMatcherBuilder withState(String key, String value) {
        this.requiresState.put(key, value);
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, Object ... values) {
        if (values.length == 0) {
            return this.queryParam(HoverflyMatchers.equalsTo(key), HoverflyMatchers.any());
        }
        for (Object value : values) {
            this.exactMatchQueries.add(String.format("%s=%s", key, value));
        }
        return this;
    }

    public RequestMatcherBuilder queryParam(String key, PlainTextFieldMatcher value) {
        return this.queryParam(HoverflyMatchers.equalsTo(key), value);
    }

    public RequestMatcherBuilder queryParam(PlainTextFieldMatcher key, String value) {
        return this.queryParam(key, HoverflyMatchers.equalsTo(value));
    }

    public RequestMatcherBuilder queryParam(PlainTextFieldMatcher key, PlainTextFieldMatcher value) {
        String queryParams = String.format("%s=%s", key.getPattern(), value.getPattern());
        if (key.getType() == RequestMatcherType.GLOB_MATCH || value.getType() == RequestMatcherType.GLOB_MATCH) {
            this.globMatchQueries.add(queryParams);
        } else if (key.getType() == RequestMatcherType.REGEX_MATCH || value.getType() == RequestMatcherType.REGEX_MATCH) {
            this.regexMatchQueries.add(queryParams);
        }
        return this;
    }

    public RequestMatcherBuilder anyQueryParams() {
        this.query = null;
        return this;
    }

    public StubServiceBuilder willReturn(ResponseBuilder responseBuilder) {
        Request request = this.build();
        return this.invoker.addRequestResponsePair(new RequestResponsePair(request, responseBuilder.build())).addDelaySetting(request, responseBuilder);
    }

    public Request build() {
        if (this.query != null) {
            this.query = this.buildQuery();
        }
        return new Request(this.path, this.method, this.destination, this.scheme, this.query, this.body, this.headers, this.requiresState);
    }

    private FieldMatcher buildQuery() {
        FieldMatcher.Builder builder = new FieldMatcher.Builder();
        if (this.globMatchQueries.isEmpty() && this.regexMatchQueries.isEmpty()) {
            builder.exactMatch(this.exactMatchQueries.stream().collect(Collectors.joining("&")));
        } else {
            if (!this.globMatchQueries.isEmpty()) {
                this.globMatchQueries.addAll(this.exactMatchQueries);
                builder.globMatch(this.globMatchQueries.stream().collect(Collectors.joining("&")));
            }
            if (!this.regexMatchQueries.isEmpty()) {
                this.regexMatchQueries.addAll(this.exactMatchQueries);
                builder.regexMatch(this.regexMatchQueries.stream().collect(Collectors.joining("&")));
            }
        }
        return builder.build();
    }
}

