/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.rule;

import io.specto.hoverfly.junit.core.Hoverfly;
import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.SimulationSource;
import io.specto.hoverfly.junit.core.SslConfigurer;
import io.specto.hoverfly.junit.dsl.RequestMatcherBuilder;
import io.specto.hoverfly.junit.dsl.StubServiceBuilder;
import io.specto.hoverfly.junit.rule.HoverflyRuleUtils;
import io.specto.hoverfly.junit.verification.VerificationCriteria;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoverflyRule
extends ExternalResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HoverflyRule.class);
    private final Hoverfly hoverfly;
    private final HoverflyMode hoverflyMode;
    private Path capturePath;
    private SimulationSource simulationSource;
    private boolean enableSimulationPrint;

    private HoverflyRule(HoverflyMode hoverflyMode, SimulationSource simulationSource, HoverflyConfig hoverflyConfig) {
        this.hoverflyMode = hoverflyMode;
        this.hoverfly = new Hoverfly(hoverflyConfig, hoverflyMode);
        this.simulationSource = simulationSource;
    }

    private HoverflyRule(Path capturePath, HoverflyConfig hoverflyConfig) {
        this.hoverflyMode = HoverflyMode.CAPTURE;
        this.hoverfly = new Hoverfly(hoverflyConfig, this.hoverflyMode);
        this.capturePath = capturePath;
    }

    public static HoverflyRule inCaptureOrSimulationMode(String recordFile) {
        return HoverflyRule.inCaptureOrSimulationMode(recordFile, HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inCaptureOrSimulationMode(String recordFile, HoverflyConfig hoverflyConfig) {
        Optional<Path> path = HoverflyRuleUtils.findResourceOnClasspath(recordFile);
        if (path.isPresent() && Files.isRegularFile(path.get(), new LinkOption[0])) {
            return HoverflyRule.inSimulationMode(SimulationSource.file(path.get()), hoverflyConfig);
        }
        return HoverflyRule.inCaptureMode(recordFile, hoverflyConfig);
    }

    public static HoverflyRule inCaptureMode() {
        return HoverflyRule.inCaptureMode(HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inCaptureMode(HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(null, hoverflyConfig);
    }

    public static HoverflyRule inCaptureMode(String outputFilename) {
        return HoverflyRule.inCaptureMode(outputFilename, HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inCaptureMode(String outputFilename, HoverflyConfig hoverflyConfig) {
        HoverflyRuleUtils.createTestResourcesHoverflyDirectoryIfNoneExisting();
        return new HoverflyRule(HoverflyRuleUtils.fileRelativeToTestResourcesHoverfly(outputFilename), hoverflyConfig);
    }

    public static HoverflyRule inSimulationMode() {
        return HoverflyRule.inSimulationMode(HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inSimulationMode(HoverflyConfig hoverflyConfig) {
        return HoverflyRule.inSimulationMode(SimulationSource.empty(), hoverflyConfig);
    }

    public static HoverflyRule inSimulationMode(SimulationSource simulationSource) {
        return HoverflyRule.inSimulationMode(simulationSource, HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inSimulationMode(SimulationSource simulationSource, HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(HoverflyMode.SIMULATE, simulationSource, hoverflyConfig);
    }

    public static HoverflyRule inSpyMode() {
        return HoverflyRule.inSpyMode(HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inSpyMode(HoverflyConfig hoverflyConfig) {
        return HoverflyRule.inSpyMode(SimulationSource.empty(), hoverflyConfig);
    }

    public static HoverflyRule inSpyMode(SimulationSource simulationSource) {
        return HoverflyRule.inSpyMode(simulationSource, HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inSpyMode(SimulationSource simulationSource, HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(HoverflyMode.SPY, simulationSource, hoverflyConfig);
    }

    public static HoverflyRule inDiffMode() {
        return HoverflyRule.inDiffMode(HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inDiffMode(HoverflyConfig hoverflyConfig) {
        return HoverflyRule.inDiffMode(SimulationSource.empty(), hoverflyConfig);
    }

    public static HoverflyRule inDiffMode(SimulationSource simulationSource) {
        return HoverflyRule.inDiffMode(simulationSource, HoverflyConfig.localConfigs());
    }

    public static HoverflyRule inDiffMode(SimulationSource simulationSource, HoverflyConfig hoverflyConfig) {
        return new HoverflyRule(HoverflyMode.DIFF, simulationSource, hoverflyConfig);
    }

    public Statement apply(Statement base, Description description) {
        if (HoverflyRuleUtils.isAnnotatedWithRule(description)) {
            LOGGER.warn("It is recommended to use HoverflyRule with @ClassRule to get better performance in your tests, and prevent known issue with Apache HttpClient. For more information, please see http://hoverfly-java.readthedocs.io/en/latest/pages/misc/misc.html#apache-httpclient.");
        }
        return super.apply(base, description);
    }

    protected void before() {
        this.hoverfly.start();
        if (this.hoverflyMode.allowSimulationImport()) {
            this.importSimulation();
        }
    }

    protected void after() {
        try {
            if (this.hoverflyMode == HoverflyMode.CAPTURE) {
                this.hoverfly.exportSimulation(this.capturePath);
            }
        }
        finally {
            this.hoverfly.close();
        }
    }

    public int getProxyPort() {
        return this.hoverfly.getHoverflyConfig().getProxyPort();
    }

    public SslConfigurer getSslConfigurer() {
        return this.hoverfly.getSslConfigurer();
    }

    public HoverflyMode getHoverflyMode() {
        return this.hoverflyMode;
    }

    public void simulate(SimulationSource simulationSource) {
        this.checkMode(HoverflyMode::allowSimulationImport);
        this.simulationSource = simulationSource;
        this.importSimulation();
        this.hoverfly.resetJournal();
    }

    public void capture(String recordFile) {
        this.checkMode(mode -> mode == HoverflyMode.CAPTURE);
        if (this.capturePath != null) {
            this.hoverfly.exportSimulation(this.capturePath);
        }
        this.hoverfly.reset();
        this.capturePath = HoverflyRuleUtils.fileRelativeToTestResourcesHoverfly(recordFile);
    }

    @Deprecated
    public String getAuthHeaderName() {
        return "X-HOVERFLY-AUTHORIZATION";
    }

    @Deprecated
    public String getAuthHeaderValue() {
        Optional<String> authToken = this.hoverfly.getHoverflyConfig().getAuthToken();
        return authToken.map(s -> "Bearer " + s).orElse(null);
    }

    public HoverflyRule printSimulationData() {
        this.enableSimulationPrint = true;
        return this;
    }

    public void verify(RequestMatcherBuilder requestMatcher) {
        this.hoverfly.verify(requestMatcher);
    }

    public void verify(RequestMatcherBuilder requestMatcher, VerificationCriteria criteria) {
        this.hoverfly.verify(requestMatcher, criteria);
    }

    public void verifyZeroRequestTo(StubServiceBuilder requestedServiceBuilder) {
        this.hoverfly.verifyZeroRequestTo(requestedServiceBuilder);
    }

    public void verifyAll() {
        this.hoverfly.verifyAll();
    }

    public void resetJournal() {
        this.hoverfly.resetJournal();
    }

    public void resetState() {
        this.hoverfly.resetState();
    }

    public Map<String, String> getState() {
        return this.hoverfly.getState();
    }

    public void setState(Map<String, String> state) {
        this.hoverfly.setState(state);
    }

    public void updateState(Map<String, String> state) {
        this.hoverfly.updateState(state);
    }

    public void resetDiffs() {
        this.hoverfly.resetDiffs();
    }

    public void assertThatNoDiffIsReported() {
        this.assertThatNoDiffIsReported(true);
    }

    public void assertThatNoDiffIsReported(boolean shouldResetDiff) {
        this.hoverfly.assertThatNoDiffIsReported(shouldResetDiff);
    }

    private void checkMode(Predicate<HoverflyMode> condition) {
        if (!condition.test(this.hoverflyMode)) {
            throw new HoverflyRuleException(this.hoverflyMode.name() + " mode does not support this operation.");
        }
    }

    private void importSimulation() {
        if (this.simulationSource == null) {
            this.simulationSource = SimulationSource.empty();
        }
        this.hoverfly.simulate(this.simulationSource);
        if (this.enableSimulationPrint) {
            HoverflyRuleUtils.prettyPrintJson(this.simulationSource.getSimulation());
        }
    }

    static class HoverflyRuleException
    extends RuntimeException {
        HoverflyRuleException(String message) {
            super(message);
        }
    }
}

