/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.api;

import io.specto.hoverfly.junit.api.OkHttpHoverflyClient;
import io.specto.hoverfly.junit.api.model.ModeArguments;
import io.specto.hoverfly.junit.api.view.HoverflyInfoView;
import io.specto.hoverfly.junit.core.HoverflyMode;
import io.specto.hoverfly.junit.core.model.Journal;
import io.specto.hoverfly.junit.core.model.Request;
import io.specto.hoverfly.junit.core.model.Simulation;

public interface HoverflyClient {
    public void setSimulation(Simulation var1);

    public Simulation getSimulation();

    public void deleteSimulation();

    public Journal getJournal();

    public Journal searchJournal(Request var1);

    public void deleteJournal();

    public void deleteStates();

    public HoverflyInfoView getConfigInfo();

    public void setDestination(String var1);

    public void setMode(HoverflyMode var1);

    public void setMode(HoverflyMode var1, ModeArguments var2);

    public boolean getHealth();

    public static Builder custom() {
        return new Builder();
    }

    public static HoverflyClient createDefault() {
        return new Builder().build();
    }

    public static class Builder {
        private String scheme = "http";
        private String host = "localhost";
        private int port = 8888;
        private String authToken = null;

        Builder() {
        }

        public Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder withAuthToken() {
            this.authToken = System.getenv("HOVERFLY_AUTH_TOKEN");
            return this;
        }

        public HoverflyClient build() {
            return new OkHttpHoverflyClient(this.scheme, this.host, this.port, this.authToken);
        }
    }
}

