/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.grpc;

import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

class HoverflyConfigValidator {
    HoverflyConfigValidator() {
    }

    HoverflyConfiguration validate(HoverflyConfiguration hoverflyConfig) {
        if (hoverflyConfig == null) {
            throw new IllegalArgumentException("HoverflyConfig cannot be null.");
        }
        if (hoverflyConfig.isWebServer()) {
            throw new UnsupportedOperationException("Webserver mode is not implemented for Hoverfly gRPC yet.");
        }
        boolean isKeyBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslKeyPath());
        boolean isCertBlank = StringUtils.isBlank((CharSequence)hoverflyConfig.getSslCertificatePath());
        if (isKeyBlank && !isCertBlank || !isKeyBlank && isCertBlank) {
            throw new IllegalArgumentException("Both SSL key and certificate files are required to override the default Hoverfly SSL.");
        }
        if (hoverflyConfig.getProxyPort() == 0) {
            hoverflyConfig.setProxyPort(HoverflyConfigValidator.findUnusedPort());
        }
        if (hoverflyConfig.getAdminPort() == 0) {
            hoverflyConfig.setAdminPort(HoverflyConfigValidator.findUnusedPort());
        }
        if (hoverflyConfig.getProxyCaCertificate().isPresent()) {
            this.checkResourceOnClasspath((String)hoverflyConfig.getProxyCaCertificate().get());
        }
        return hoverflyConfig;
    }

    static String findLicenseFileOnClasspath(String filepath) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Optional.ofNullable(classLoader.getResource(filepath)).map(url -> {
            try {
                return url.toURI();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Failed to get license file path", e);
            }
        }).map(Paths::get).map(Path::toString).orElseThrow(() -> new IllegalStateException("'hoverfly_license' files is not found in classpath"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findUnusedPort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot find available port", e);
        }
    }

    private void checkResourceOnClasspath(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Optional.ofNullable(classLoader.getResource(resourceName)).orElseThrow(() -> new IllegalArgumentException("Resource not found with name: " + resourceName));
    }
}

